/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.httpclient.apache.httpcomponents.DefaultHttpClientFactory;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.jira.rest.client.api.AuthenticationHandler;
import com.atlassian.jira.rest.client.api.JiraRestClientFactory;
import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.auth.BasicHttpAuthenticationHandler;
import com.atlassian.jira.rest.client.internal.async.AtlassianHttpClientDecorator;
import com.atlassian.jira.rest.client.internal.async.DisposableHttpClient;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.cloudbees.hudson.plugins.folder.AbstractFolder;
import com.cloudbees.hudson.plugins.folder.Folder;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Job;
import hudson.plugins.jira.CredentialsHelper;
import hudson.plugins.jira.JiraFolderProperty;
import hudson.plugins.jira.JiraGlobalConfiguration;
import hudson.plugins.jira.JiraProjectProperty;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSessionFactory;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.extension.ExtendedAsynchronousJiraRestClient;
import hudson.plugins.jira.extension.ExtendedJiraRestClient;
import hudson.plugins.jira.extension.ExtendedVersion;
import hudson.plugins.jira.model.JiraIssue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class JiraSite
extends AbstractDescribableImpl<JiraSite> {
    private static final Logger LOGGER = Logger.getLogger(JiraSite.class.getName());
    public static final Pattern DEFAULT_ISSUE_PATTERN = Pattern.compile("([a-zA-Z][a-zA-Z0-9_]+-[1-9][0-9]*)([^.]|\\.[^0-9]|\\.$|$)");
    public static final int DEFAULT_TIMEOUT = 10;
    public static final int DEFAULT_READ_TIMEOUT = 30;
    public static final int DEFAULT_THREAD_EXECUTOR_NUMBER = 10;
    public static final Integer DEFAULT_ISSUES_FROM_JQL = 100;
    public static final Integer MAX_ALLOWED_ISSUES_FROM_JQL = 5000;
    public final URL url;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public URL alternativeUrl;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean useHTTPAuth;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public String credentialsId;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean useBearerAuth;
    @Deprecated
    private transient String userName;
    @Deprecated
    private transient Secret password;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public String groupVisibility;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public String roleVisibility;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean supportsWikiStyleComment;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean recordScmChanges;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean disableChangelogAnnotations;
    private String userPattern;
    private transient Pattern userPat;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public boolean updateJiraIssueForAllStatus;
    @SuppressFBWarnings(value={"PA_PUBLIC_PRIMITIVE_ATTRIBUTE"}, justification="Backwards compatibility")
    public int timeout = 10;
    private int readTimeout = 30;
    private int threadExecutorNumber = 10;
    private String dateTimePattern;
    private boolean appendChangeTimestamp;
    private int maxIssuesFromJqlSearch = DEFAULT_ISSUES_FROM_JQL;
    private int ioThreadCount = Integer.getInteger(JiraSite.class.getName() + ".httpclient.options.ioThreadCount", 2);
    private volatile transient Set<String> projects;
    private transient Cache<String, Optional<Issue>> issueCache = JiraSite.makeIssueCache();
    private transient Lock projectUpdateLock = new ReentrantLock();
    private transient JiraSession jiraSession;
    private static ExecutorService executorService;

    @Deprecated
    public JiraSite(URL url, @CheckForNull URL alternativeUrl, @CheckForNull String credentialsId, boolean supportsWikiStyleComment, boolean recordScmChanges, @CheckForNull String userPattern, boolean updateJiraIssueForAllStatus, @CheckForNull String groupVisibility, @CheckForNull String roleVisibility, boolean useHTTPAuth) {
        this(url, alternativeUrl, credentialsId, supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth, 10, 30, 10);
    }

    @Deprecated
    public JiraSite(URL url, @CheckForNull URL alternativeUrl, String userName, String password, boolean supportsWikiStyleComment, boolean recordScmChanges, @CheckForNull String userPattern, boolean updateJiraIssueForAllStatus, @CheckForNull String groupVisibility, @CheckForNull String roleVisibility, boolean useHTTPAuth) throws Descriptor.FormException {
        this(url, alternativeUrl, CredentialsHelper.migrateCredentials(userName, password, url), supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth);
    }

    @Deprecated
    public JiraSite(URL url, URL alternativeUrl, StandardUsernamePasswordCredentials credentials, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility, boolean useHTTPAuth) throws Descriptor.FormException {
        this(url, alternativeUrl, (String)null, supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth, 10, 30, 10);
        StandardUsernamePasswordCredentials standardUsernamePasswordCredentials;
        if (credentials != null && (standardUsernamePasswordCredentials = CredentialsHelper.lookupSystemCredentials(credentials.getId(), url)) == null) {
            credentials = CredentialsHelper.migrateCredentials(credentials.getUsername(), credentials.getPassword().getPlainText(), url);
        }
        this.setCredentialsId(credentials == null ? null : credentials.getId());
    }

    @Deprecated
    public JiraSite(URL url, URL alternativeUrl, String credentialsId, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility, boolean useHTTPAuth, int timeout, int readTimeout, int threadExecutorNumber) {
        if (url != null) {
            url = JiraSite.toURL(url.toExternalForm());
        }
        if (alternativeUrl != null) {
            alternativeUrl = JiraSite.toURL(alternativeUrl.toExternalForm());
        }
        this.url = url;
        this.credentialsId = credentialsId;
        this.timeout = timeout;
        this.readTimeout = readTimeout;
        this.threadExecutorNumber = threadExecutorNumber;
        this.alternativeUrl = alternativeUrl;
        this.supportsWikiStyleComment = supportsWikiStyleComment;
        this.recordScmChanges = recordScmChanges;
        this.setUserPattern(userPattern);
        this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
        this.setGroupVisibility(groupVisibility);
        this.setRoleVisibility(roleVisibility);
        this.useHTTPAuth = useHTTPAuth;
        this.jiraSession = null;
    }

    @DataBoundConstructor
    public JiraSite(String url) {
        URL mainURL = JiraSite.toURL(url);
        if (mainURL == null) {
            throw new AssertionError((Object)"URL cannot be empty");
        }
        this.url = mainURL;
    }

    @Deprecated
    public JiraSite(URL url, URL alternativeUrl, StandardUsernamePasswordCredentials credentials, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility, boolean useHTTPAuth, int timeout, int readTimeout, int threadExecutorNumber) {
        this(url, alternativeUrl, credentials == null ? null : credentials.getId(), supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth, timeout, readTimeout, threadExecutorNumber);
    }

    @Deprecated
    public JiraSite(URL url, URL alternativeUrl, StandardUsernamePasswordCredentials credentials, boolean supportsWikiStyleComment, boolean recordScmChanges, String userPattern, boolean updateJiraIssueForAllStatus, String groupVisibility, String roleVisibility, boolean useHTTPAuth, int timeout, int readTimeout, int threadExecutorNumber, boolean useBearerAuth) {
        this(url, alternativeUrl, credentials == null ? null : credentials.getId(), supportsWikiStyleComment, recordScmChanges, userPattern, updateJiraIssueForAllStatus, groupVisibility, roleVisibility, useHTTPAuth, timeout, readTimeout, threadExecutorNumber);
        this.useBearerAuth = useBearerAuth;
    }

    static URL toURL(String url) {
        if ((url = Util.fixEmptyAndTrim((String)url)) == null) {
            return null;
        }
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            return new URL((String)url);
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)e);
        }
    }

    @DataBoundSetter
    public void setDisableChangelogAnnotations(boolean disableChangelogAnnotations) {
        this.disableChangelogAnnotations = disableChangelogAnnotations;
    }

    public boolean getDisableChangelogAnnotations() {
        return this.disableChangelogAnnotations;
    }

    @DataBoundSetter
    public void setTimeout(int timeoutSec) {
        this.timeout = timeoutSec;
    }

    public int getTimeout() {
        return this.timeout;
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmptyAndTrim((String)credentialsId);
    }

    @DataBoundSetter
    public void setDateTimePattern(String dateTimePattern) {
        this.dateTimePattern = Util.fixEmptyAndTrim((String)dateTimePattern);
    }

    @DataBoundSetter
    public void setThreadExecutorNumber(int threadExecutorNumber) {
        this.threadExecutorNumber = threadExecutorNumber;
    }

    public int getThreadExecutorNumber() {
        return this.threadExecutorNumber;
    }

    @DataBoundSetter
    public void setAppendChangeTimestamp(boolean appendChangeTimestamp) {
        this.appendChangeTimestamp = appendChangeTimestamp;
    }

    public String getDateTimePattern() {
        return this.dateTimePattern;
    }

    public boolean isAppendChangeTimestamp() {
        return this.appendChangeTimestamp;
    }

    public URL getAlternativeUrl() {
        return this.alternativeUrl;
    }

    public boolean isUseHTTPAuth() {
        return this.useHTTPAuth;
    }

    public boolean isUseBearerAuth() {
        return this.useBearerAuth;
    }

    public String getGroupVisibility() {
        return this.groupVisibility;
    }

    public String getRoleVisibility() {
        return this.roleVisibility;
    }

    public boolean isSupportsWikiStyleComment() {
        return this.supportsWikiStyleComment;
    }

    public boolean isRecordScmChanges() {
        return this.recordScmChanges;
    }

    public boolean isUpdateJiraIssueForAllStatus() {
        return this.updateJiraIssueForAllStatus;
    }

    @DataBoundSetter
    public void setAlternativeUrl(String alternativeUrl) {
        this.alternativeUrl = JiraSite.toURL(alternativeUrl);
    }

    @DataBoundSetter
    public void setUseHTTPAuth(boolean useHTTPAuth) {
        this.useHTTPAuth = useHTTPAuth;
    }

    @DataBoundSetter
    public void setUseBearerAuth(boolean useBearerAuth) {
        this.useBearerAuth = useBearerAuth;
    }

    @DataBoundSetter
    public void setGroupVisibility(String groupVisibility) {
        this.groupVisibility = Util.fixEmptyAndTrim((String)groupVisibility);
    }

    @DataBoundSetter
    public void setRoleVisibility(String roleVisibility) {
        this.roleVisibility = Util.fixEmptyAndTrim((String)roleVisibility);
    }

    @DataBoundSetter
    public void setSupportsWikiStyleComment(boolean supportsWikiStyleComment) {
        this.supportsWikiStyleComment = supportsWikiStyleComment;
    }

    @DataBoundSetter
    public void setRecordScmChanges(boolean recordScmChanges) {
        this.recordScmChanges = recordScmChanges;
    }

    @DataBoundSetter
    public void setUserPattern(String userPattern) {
        this.userPattern = Util.fixEmptyAndTrim((String)userPattern);
        this.userPat = this.userPattern == null ? null : Pattern.compile(this.userPattern);
    }

    @DataBoundSetter
    public void setUpdateJiraIssueForAllStatus(boolean updateJiraIssueForAllStatus) {
        this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
    }

    @DataBoundSetter
    public void setMaxIssuesFromJqlSearch(int maxIssuesFromJqlSearch) {
        this.maxIssuesFromJqlSearch = maxIssuesFromJqlSearch > MAX_ALLOWED_ISSUES_FROM_JQL ? MAX_ALLOWED_ISSUES_FROM_JQL : maxIssuesFromJqlSearch;
    }

    public int getMaxIssuesFromJqlSearch() {
        return this.maxIssuesFromJqlSearch;
    }

    protected Object readResolve() throws Descriptor.FormException {
        JiraSite jiraSite = this.credentialsId == null && this.userName != null && this.password != null ? new JiraSite(this.url, this.alternativeUrl, this.userName, this.password.getPlainText(), this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth) : new JiraSite(this.url, this.alternativeUrl, this.credentialsId, this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth, this.timeout, this.readTimeout, this.threadExecutorNumber);
        jiraSite.setAppendChangeTimestamp(this.appendChangeTimestamp);
        jiraSite.setDisableChangelogAnnotations(this.disableChangelogAnnotations);
        jiraSite.setDateTimePattern(this.dateTimePattern);
        jiraSite.setUseBearerAuth(this.useBearerAuth);
        if (this.maxIssuesFromJqlSearch <= 0) {
            jiraSite.setMaxIssuesFromJqlSearch(DEFAULT_ISSUES_FROM_JQL);
        } else {
            jiraSite.setMaxIssuesFromJqlSearch(this.maxIssuesFromJqlSearch);
        }
        return jiraSite;
    }

    protected static Cache<String, Optional<Issue>> makeIssueCache() {
        return Caffeine.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).build();
    }

    public String getName() {
        return this.url.toExternalForm();
    }

    @Deprecated
    public JiraSession getSession() {
        return this.getSession(null);
    }

    @Nullable
    public JiraSession getSession(Item item) {
        return this.getSession(item, false);
    }

    JiraSession getSession(Item item, boolean uiValidation) {
        if (this.jiraSession == null) {
            this.jiraSession = this.createSession(item, uiValidation);
        }
        return this.jiraSession;
    }

    JiraSession createSession(Item item) {
        return this.createSession(item, false);
    }

    JiraSession createSession(Item item, boolean uiValidation) {
        URI uri;
        ItemGroup itemGroup = JiraSite.map(item);
        StandardUsernamePasswordCredentials credentials = this.resolveCredentials(item = itemGroup instanceof Folder ? (Folder)itemGroup : item, uiValidation);
        if (credentials == null) {
            LOGGER.fine("no Jira credentials available for " + String.valueOf(item));
            return null;
        }
        try {
            uri = this.url.toURI();
        }
        catch (URISyntaxException e) {
            LOGGER.warning("convert URL to URI error: " + e.getMessage());
            throw new RuntimeException("failed to create JiraSession due to convert URI error");
        }
        LOGGER.fine("creating Jira Session: " + String.valueOf(uri));
        return JiraSessionFactory.create(this, uri, credentials);
    }

    Lock getProjectUpdateLock() {
        return this.projectUpdateLock;
    }

    private StandardUsernamePasswordCredentials resolveCredentials(Item item, boolean uiValidation) {
        if (this.credentialsId == null) {
            LOGGER.fine("credentialsId is null");
            return null;
        }
        List req = URIRequirementBuilder.fromUri(this.url != null ? this.url.toExternalForm() : null).build();
        if (item != null) {
            StandardUsernamePasswordCredentials credentials = (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, (List)req), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
            if (credentials != null) {
                return credentials;
            }
            if (uiValidation) {
                return null;
            }
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, (List)req), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialsId));
    }

    protected HttpClientOptions getHttpClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        options.setRequestTimeout(this.readTimeout, TimeUnit.SECONDS);
        options.setSocketTimeout(this.timeout, TimeUnit.SECONDS);
        options.setCallbackExecutor(this.getExecutorService());
        options.setIoThreadCount(this.ioThreadCount);
        return options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<JiraSite> clazz = JiraSite.class;
        synchronized (JiraSite.class) {
            int nThreads = this.threadExecutorNumber;
            if (nThreads < 1) {
                LOGGER.warning("nThreads " + nThreads + " cannot be lower than 1 so use default 10");
                nThreads = 10;
            }
            executorService = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){
                final AtomicInteger threadNumber = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, "jira-plugin-http-request-" + this.threadNumber.getAndIncrement() + "-thread");
                }
            });
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    @PreDestroy
    public void destroy() {
        try {
            this.jiraSession = null;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "skip error destroying JiraSite:" + e.getMessage(), e);
        }
    }

    private static DisposableHttpClient createClient(URI serverUri, AuthenticationHandler authenticationHandler, HttpClientOptions options) {
        final DefaultHttpClientFactory defaultHttpClientFactory = new DefaultHttpClientFactory(new NoOpEventPublisher(), new RestClientApplicationProperties(serverUri), new ThreadLocalContextManager(){

            public Object getThreadLocalContext() {
                return null;
            }

            public void setThreadLocalContext(Object context) {
            }

            public void clearThreadLocalContext() {
            }
        });
        final HttpClient httpClient = defaultHttpClientFactory.create(options);
        return new AtlassianHttpClientDecorator(httpClient, authenticationHandler){

            public void destroy() throws Exception {
                defaultHttpClientFactory.dispose(httpClient);
            }
        };
    }

    private static DisposableHttpClient createClient(HttpClient client) {
        return new AtlassianHttpClientDecorator(client, null){

            public void destroy() throws Exception {
            }
        };
    }

    @Nullable
    public URL getUrl() {
        return this.url != null ? this.url : this.alternativeUrl;
    }

    public URL getUrl(JiraIssue issue) throws IOException {
        return this.getUrl(issue.getKey());
    }

    public URL getUrl(String id) throws MalformedURLException {
        return new URL(this.url, "browse/" + id.toUpperCase());
    }

    public URL getAlternativeUrl(String id) throws MalformedURLException {
        return this.alternativeUrl == null ? null : new URL(this.alternativeUrl, "browse/" + id.toUpperCase());
    }

    public Pattern getUserPattern() {
        if (this.userPattern == null) {
            return null;
        }
        if (this.userPat == null) {
            this.userPat = Pattern.compile(this.userPattern);
        }
        return this.userPat;
    }

    public Pattern getIssuePattern() {
        Pattern result = this.getUserPattern();
        return result == null ? DEFAULT_ISSUE_PATTERN : result;
    }

    public Set<String> getProjectKeys(Item item) {
        block9: {
            if (this.projects == null) {
                try {
                    if (!this.getProjectUpdateLock().tryLock(3L, TimeUnit.SECONDS)) break block9;
                    try {
                        JiraSession session = this.getSession(item);
                        if (session != null) {
                            this.projects = Collections.unmodifiableSet(session.getProjectKeys());
                        }
                    }
                    finally {
                        this.getProjectUpdateLock().unlock();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RestClientException e) {
                    return Collections.emptySet();
                }
            }
        }
        if (this.projects == null) {
            return Collections.emptySet();
        }
        return this.projects;
    }

    @CheckForNull
    public JiraIssue getIssue(String id) throws IOException {
        Optional issue = (Optional)this.issueCache.get((Object)id, s -> {
            if (this.jiraSession == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.jiraSession.getIssue(id));
        });
        if (issue == null || !issue.isPresent()) {
            return null;
        }
        return new JiraIssue((Issue)issue.get());
    }

    @Deprecated
    public boolean existsIssue(String id) {
        try {
            return this.getIssue(id) != null;
        }
        catch (RestClientException | IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Deprecated
    public Set<ExtendedVersion> getVersions(String projectKey) {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            return Collections.emptySet();
        }
        return new HashSet<ExtendedVersion>(this.jiraSession.getVersions(projectKey));
    }

    public String getReleaseNotesForFixVersion(String projectKey, String versionName, String filter) throws TimeoutException {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            return "";
        }
        List<Issue> issues = this.jiraSession.getIssuesWithFixVersion(projectKey, versionName, filter);
        if (issues.isEmpty()) {
            return "";
        }
        HashMap releaseNotes = new HashMap();
        for (Issue issue : issues) {
            Set<String> issueSet;
            String key = issue.getKey();
            String summary = issue.getSummary();
            String status = issue.getStatus().getName();
            String type = issue.getIssueType().getName();
            if (releaseNotes.containsKey(type)) {
                issueSet = (Set)releaseNotes.get(type);
            } else {
                issueSet = new HashSet();
                releaseNotes.put(type, issueSet);
            }
            issueSet.add(String.format(" - [%s] %s (%s)", key, summary, status));
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : releaseNotes.entrySet()) {
            sb.append(String.format("# %s%n", entry.getKey()));
            for (String issue : (Set)entry.getValue()) {
                sb.append(issue);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public void replaceFixVersion(String projectKey, String fromVersion, String toVersion, String query) throws TimeoutException, RestClientException {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        this.jiraSession.replaceFixVersion(projectKey, fromVersion, toVersion, query);
    }

    public void migrateIssuesToFixVersion(String projectKey, String versionName, String query) throws TimeoutException {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        this.jiraSession.migrateIssuesToFixVersion(projectKey, versionName, query);
    }

    public void addFixVersionToIssue(String projectKey, String versionName, String query) throws TimeoutException, RestClientException {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            return;
        }
        this.jiraSession.addFixVersion(projectKey, versionName, query);
    }

    public boolean progressMatchingIssues(String jqlSearch, String workflowActionName, String comment, PrintStream console) throws RestClientException {
        if (this.jiraSession == null) {
            LOGGER.warning("Jira session could not be established");
            console.println(Messages.FailedToConnect());
            return false;
        }
        boolean success = true;
        List<Issue> issues = this.jiraSession.getIssuesFromJqlSearch(jqlSearch);
        if (StringUtils.isEmpty((String)workflowActionName)) {
            console.println("[Jira] No workflow action was specified, thus no status update will be made for any of the matching issues.");
        }
        for (Issue issue : issues) {
            String issueKey = issue.getKey();
            if (StringUtils.isNotEmpty((String)comment)) {
                this.jiraSession.addComment(issueKey, comment, null, null);
            }
            if (StringUtils.isEmpty((String)workflowActionName)) continue;
            Integer actionId = this.jiraSession.getActionIdForIssue(issueKey, workflowActionName);
            if (actionId == null) {
                LOGGER.fine(String.format("Invalid workflow action %s for issue %s; issue status = %s", workflowActionName, issueKey, issue.getStatus()));
                console.println(Messages.JiraIssueUpdateBuilder_UnknownWorkflowAction(issueKey, workflowActionName));
                success = false;
                continue;
            }
            String newStatus = this.jiraSession.progressWorkflowAction(issueKey, actionId);
            console.println(String.format("[Jira] Issue %s transitioned to \"%s\" due to action \"%s\".", issueKey, newStatus, workflowActionName));
        }
        return success;
    }

    public static ItemGroup map(Item item) {
        Folder parent = null;
        if (item != null) {
            parent = item instanceof Folder ? (Folder)item : item.getParent();
        }
        return parent;
    }

    public static List<JiraSite> getJiraSites(Item item) {
        ItemGroup itemGroup = JiraSite.map(item);
        List<JiraSite> sites = itemGroup instanceof Folder ? JiraSite.getSitesFromFolders(itemGroup) : JiraGlobalConfiguration.get().getSites();
        sites.stream().forEach(jiraSite -> jiraSite.getSession(item));
        return sites;
    }

    public static List<JiraSite> getSitesFromFolders(ItemGroup itemGroup) {
        ArrayList<JiraSite> result = new ArrayList<JiraSite>();
        while (itemGroup instanceof AbstractFolder) {
            AbstractFolder folder = (AbstractFolder)itemGroup;
            JiraFolderProperty jiraFolderProperty = (JiraFolderProperty)folder.getProperties().get(JiraFolderProperty.class);
            if (jiraFolderProperty != null && jiraFolderProperty.getSites().length != 0) {
                List<JiraSite> sites = Arrays.asList(jiraFolderProperty.getSites());
                sites.forEach(jiraSite -> jiraSite.getSession((Item)folder));
                result.addAll(sites);
            }
            itemGroup = folder.getParent();
        }
        return result;
    }

    @Nullable
    public static JiraSite get(Job<?, ?> p) {
        List<JiraSite> sites;
        List<JiraSite> sitesFromFolders;
        JiraSite site;
        JiraProjectProperty jpp;
        JiraSite found = null;
        if (p != null && (jpp = (JiraProjectProperty)p.getProperty(JiraProjectProperty.class)) != null && (site = jpp.getSite()) != null) {
            found = site;
        }
        if (found == null && p != null && (sitesFromFolders = JiraSite.getSitesFromFolders(p.getParent())).size() > 0) {
            found = sitesFromFolders.get(0);
        }
        if (found == null && (sites = JiraGlobalConfiguration.get().getSites()) != null && sites.size() == 1) {
            found = sites.get(0);
        }
        if (found != null) {
            found.getSession((Item)p);
        }
        return found;
    }

    private static class NoOpEventPublisher
    implements EventPublisher {
        private NoOpEventPublisher() {
        }

        public void publish(Object o) {
        }

        public void register(Object o) {
        }

        public void unregister(Object o) {
        }

        public void unregisterAll() {
        }
    }

    private static class RestClientApplicationProperties
    implements ApplicationProperties {
        private final String baseUrl;

        private RestClientApplicationProperties(URI jiraURI) {
            this.baseUrl = jiraURI.getPath();
        }

        public String getBaseUrl() {
            return this.baseUrl;
        }

        @NonNull
        public String getBaseUrl(UrlMode urlMode) {
            return this.baseUrl;
        }

        @NonNull
        public String getDisplayName() {
            return "Atlassian Jira Rest Java Client";
        }

        @NonNull
        public String getPlatformId() {
            return "jira";
        }

        @NonNull
        public String getVersion() {
            return "";
        }

        @NonNull
        public Date getBuildDate() {
            throw new UnsupportedOperationException();
        }

        @NonNull
        public String getBuildNumber() {
            return String.valueOf(0);
        }

        public File getHomeDirectory() {
            return new File(".");
        }

        public String getPropertyValue(String s) {
            throw new UnsupportedOperationException("Not implemented");
        }

        @NonNull
        public String getApplicationFileEncoding() {
            return System.getProperty("file.encoding");
        }

        @NonNull
        public Optional<Path> getLocalHomeDirectory() {
            return Optional.empty();
        }

        @NonNull
        public Optional<Path> getSharedHomeDirectory() {
            return Optional.empty();
        }
    }

    static class Builder {
        private URL mainURL;
        private URL alternativeURL;
        private String credentialsId;
        private boolean supportsWikiStyleComment;
        private boolean recordScmChanges;
        private String userPattern;
        private boolean updateJiraIssueForAllStatus;
        private String groupVisibility;
        private String roleVisibility;
        private boolean useHTTPAuth;

        Builder() {
        }

        public Builder withMainURL(URL mainURL) {
            this.mainURL = mainURL;
            return this;
        }

        public Builder withAlternativeURL(URL alternativeURL) {
            this.alternativeURL = alternativeURL;
            return this;
        }

        public Builder withCredentialsId(String credentialsId) {
            this.credentialsId = credentialsId;
            return this;
        }

        public Builder withSupportsWikiStyleComment(boolean supportsWikiStyleComment) {
            this.supportsWikiStyleComment = supportsWikiStyleComment;
            return this;
        }

        public Builder withRecordScmChanges(boolean recordScmChanges) {
            this.recordScmChanges = recordScmChanges;
            return this;
        }

        public Builder withUserPattern(String userPattern) {
            this.userPattern = userPattern;
            return this;
        }

        public Builder withUpdateJiraIssueForAllStatus(boolean updateJiraIssueForAllStatus) {
            this.updateJiraIssueForAllStatus = updateJiraIssueForAllStatus;
            return this;
        }

        public Builder withGroupVisibility(String groupVisibility) {
            this.groupVisibility = groupVisibility;
            return this;
        }

        public Builder withRoleVisibility(String roleVisibility) {
            this.roleVisibility = roleVisibility;
            return this;
        }

        public Builder withUseHTTPAuth(boolean useHTTPAuth) {
            this.useHTTPAuth = useHTTPAuth;
            return this;
        }

        public JiraSite build() {
            return new JiraSite(this.mainURL, this.alternativeURL, this.credentialsId, this.supportsWikiStyleComment, this.recordScmChanges, this.userPattern, this.updateJiraIssueForAllStatus, this.groupVisibility, this.roleVisibility, this.useHTTPAuth);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<JiraSite> {
        public String getDisplayName() {
            return "Jira Site";
        }

        public FormValidation doCheckUrl(@QueryParameter String value) throws IOException, ServletException {
            return this.checkUrl(value);
        }

        public FormValidation doCheckAlternativeUrl(@QueryParameter String value) throws IOException, ServletException {
            return this.checkUrl(value);
        }

        private FormValidation checkUrl(String url) {
            if (Util.fixEmptyAndTrim((String)url) == null) {
                return FormValidation.ok();
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            return FormValidation.ok();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @RequirePOST
        public FormValidation doValidate(@QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter String groupVisibility, @QueryParameter String roleVisibility, @QueryParameter boolean useHTTPAuth, @QueryParameter String alternativeUrl, @QueryParameter int timeout, @QueryParameter int readTimeout, @QueryParameter int threadExecutorNumber, @QueryParameter boolean useBearerAuth, @AncestorInPath Item item) {
            URL mainURL;
            if (item == null) {
                Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            } else {
                item.checkPermission(Item.CONFIGURE);
            }
            url = Util.fixEmpty((String)url);
            alternativeUrl = Util.fixEmpty((String)alternativeUrl);
            URL alternativeURL = null;
            try {
                if (url == null) {
                    return FormValidation.error((String)"No URL given");
                }
                mainURL = new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            try {
                if (alternativeUrl != null) {
                    alternativeURL = new URL(alternativeUrl);
                }
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed alternative URL (%s)", alternativeUrl), (Object[])new Object[]{e});
            }
            credentialsId = Util.fixEmpty((String)credentialsId);
            JiraSite site = this.getBuilder().withMainURL(mainURL).withAlternativeURL(alternativeURL).withCredentialsId(credentialsId).withGroupVisibility(groupVisibility).withRoleVisibility(roleVisibility).withUseHTTPAuth(useHTTPAuth).build();
            if (threadExecutorNumber < 1) {
                return FormValidation.error((String)Messages.JiraSite_threadExecutorMinimunSize("1"));
            }
            if (timeout < 0) {
                return FormValidation.error((String)Messages.JiraSite_timeoutMinimunValue("1"));
            }
            if (readTimeout < 0) {
                return FormValidation.error((String)Messages.JiraSite_readTimeoutMinimunValue("1"));
            }
            site.setTimeout(timeout);
            site.setReadTimeout(readTimeout);
            site.setThreadExecutorNumber(threadExecutorNumber);
            site.setUseBearerAuth(useBearerAuth);
            try {
                JiraSession session = site.getSession(item, true);
                if (session == null) {
                    FormValidation formValidation = FormValidation.error((String)"Cannot validate configuration");
                    return formValidation;
                }
                session.getMyPermissions();
                FormValidation formValidation = FormValidation.ok((String)"Success");
                return formValidation;
            }
            catch (RestClientException e) {
                LOGGER.log(Level.WARNING, "Failed to login to Jira at " + url, e);
            }
            finally {
                if (site != null) {
                    site.destroy();
                }
            }
            return FormValidation.error((String)"Failed to login to Jira");
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String url) {
            return CredentialsHelper.doFillCredentialsIdItems(item, credentialsId, url);
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value, @QueryParameter String url) {
            return CredentialsHelper.doCheckFillCredentialsId(item, value, url);
        }

        Builder getBuilder() {
            return new Builder();
        }
    }

    public static class ExtendedAsynchronousJiraRestClientFactory
    implements JiraRestClientFactory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ExtendedJiraRestClient create(URI serverUri, AuthenticationHandler authenticationHandler, HttpClientOptions options) {
            DisposableHttpClient httpClient = JiraSite.createClient(serverUri, authenticationHandler, options);
            Thread t = Thread.currentThread();
            ClassLoader orig = t.getContextClassLoader();
            t.setContextClassLoader(JiraSite.class.getClassLoader());
            try {
                ExtendedAsynchronousJiraRestClient extendedAsynchronousJiraRestClient = new ExtendedAsynchronousJiraRestClient(serverUri, httpClient);
                return extendedAsynchronousJiraRestClient;
            }
            finally {
                t.setContextClassLoader(orig);
            }
        }

        public ExtendedJiraRestClient create(URI serverUri, AuthenticationHandler authenticationHandler) {
            DisposableHttpClient httpClient = JiraSite.createClient(serverUri, authenticationHandler, new HttpClientOptions());
            return new ExtendedAsynchronousJiraRestClient(serverUri, httpClient);
        }

        public ExtendedJiraRestClient createWithBasicHttpAuthentication(URI serverUri, String username, String password) {
            return this.create(serverUri, (AuthenticationHandler)new BasicHttpAuthenticationHandler(username, password));
        }

        public ExtendedJiraRestClient createWithAuthenticationHandler(URI serverUri, AuthenticationHandler authenticationHandler) {
            return this.create(serverUri, authenticationHandler);
        }

        public ExtendedJiraRestClient create(URI serverUri, HttpClient httpClient) {
            DisposableHttpClient disposableHttpClient = JiraSite.createClient(httpClient);
            return new ExtendedAsynchronousJiraRestClient(serverUri, disposableHttpClient);
        }
    }
}

