/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.TaskListener;
import hudson.model.listeners.RunListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.model.JiraIssue;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.branch.MultiBranchProject;
import org.jenkinsci.plugins.workflow.job.WorkflowJob;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JiraJobAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(JiraJobAction.class.getName());
    private final Job<?, ?> owner;
    private final JiraIssue issue;

    @DataBoundConstructor
    public JiraJobAction(Job<?, ?> owner, JiraIssue issue) {
        this.owner = owner;
        this.issue = issue;
    }

    @Exported
    public JiraIssue getIssue() {
        return this.issue;
    }

    @Exported
    @Nullable
    public String getServerURL() {
        JiraSite jiraSite = JiraSite.get(this.owner);
        URL url = jiraSite != null ? jiraSite.getUrl() : null;
        return url != null ? url.toString() : null;
    }

    public static void setAction(@NonNull Job job, @NonNull JiraSite site) throws IOException {
        JiraIssue issue;
        if (job.getAction(JiraJobAction.class) != null) {
            return;
        }
        if (!(job.getParent() instanceof MultiBranchProject)) {
            return;
        }
        Pattern pattern = site.getIssuePattern();
        String decodedJobName = URLDecoder.decode(job.getName(), "UTF-8");
        String issueKey = null;
        Matcher m = pattern.matcher(decodedJobName);
        while (m.find()) {
            if (m.groupCount() < 1) continue;
            issueKey = m.group(1);
            break;
        }
        if (issueKey != null && (issue = site.getIssue(issueKey)) != null) {
            job.addAction((Action)new JiraJobAction(job, issue));
            job.save();
        }
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return "Jira";
    }

    public String getUrlName() {
        return "jira";
    }

    @Extension
    public static final class RunListenerImpl
    extends RunListener<WorkflowRun> {
        public void onStarted(WorkflowRun workflowRun, TaskListener listener) {
            WorkflowJob parent = (WorkflowJob)workflowRun.getParent();
            JiraSite site = JiraSite.get(parent);
            if (site != null) {
                try {
                    JiraJobAction.setAction((Job)parent, site);
                }
                catch (RestClientException | IOException e) {
                    LOGGER.log(Level.WARNING, "Could not set JiraJobAction for <" + parent.getFullName() + ">", e);
                    listener.getLogger().println(e.getMessage());
                }
            }
        }
    }
}

