/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraEnvironmentContributingAction;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.plugins.jira.selector.DefaultIssueSelector;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.Set;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraEnvironmentVariableBuilder
extends Builder {
    private AbstractIssueSelector issueSelector;

    @DataBoundConstructor
    public JiraEnvironmentVariableBuilder(AbstractIssueSelector issueSelector) {
        this.issueSelector = issueSelector;
    }

    public AbstractIssueSelector getIssueSelector() {
        AbstractIssueSelector uis = this.issueSelector;
        if (uis == null) {
            uis = new DefaultIssueSelector();
        }
        this.issueSelector = uis;
        return this.issueSelector;
    }

    JiraSite getSiteForProject(AbstractProject<?, ?> project) {
        return JiraSite.get(project);
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        Set<String> ids;
        JiraSite site = this.getSiteForProject(build.getProject());
        if (site == null) {
            listener.getLogger().println(Messages.JiraEnvironmentVariableBuilder_NoJiraSite());
            return false;
        }
        try {
            ids = this.getIssueSelector().findIssueIds((Run<?, ?>)build, site, (TaskListener)listener);
        }
        catch (RestClientException e) {
            listener.getLogger().println(e.getMessage());
            return false;
        }
        String idList = StringUtils.join(ids, (String)",");
        Integer idListSize = ids.size();
        listener.getLogger().println(Messages.JiraEnvironmentVariableBuilder_Updating("JIRA_ISSUES", idList));
        listener.getLogger().println(Messages.JiraEnvironmentVariableBuilder_Updating("JIRA_ISSUES_SIZE", idListSize));
        build.addAction((Action)new JiraEnvironmentContributingAction(idList, idListSize, site.getName()));
        return true;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> klass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraEnvironmentVariableBuilder_DisplayName();
        }

        public boolean hasIssueSelectors() {
            return Jenkins.get().getDescriptorList(AbstractIssueSelector.class).size() > 0;
        }
    }
}

