/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.Run;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.model.JiraIssue;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import jenkins.model.RunAction2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class JiraBuildAction
implements RunAction2 {
    private final HashSet<JiraIssue> issues;
    private transient Run<?, ?> owner;

    public JiraBuildAction(@NonNull Set<JiraIssue> issues) {
        this.issues = new HashSet<JiraIssue>(issues);
    }

    @Deprecated
    public JiraBuildAction(Run<?, ?> owner, @NonNull Set<JiraIssue> issues) {
        this(issues);
    }

    public void onAttached(Run<?, ?> r) {
        this.owner = r;
    }

    public void onLoad(Run<?, ?> r) {
        this.owner = r;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return Messages.JiraBuildAction_DisplayName();
    }

    public String getUrlName() {
        return "jira";
    }

    public Run<?, ?> getOwner() {
        return this.owner;
    }

    @Exported(inline=true)
    public Set<JiraIssue> getIssues() {
        return this.issues;
    }

    @Exported
    public String getServerURL() {
        JiraSite jiraSite = JiraSite.get(this.owner.getParent());
        URL url = jiraSite != null ? jiraSite.getUrl() : null;
        return url != null ? url.toString() : null;
    }

    public JiraIssue getIssue(String issueID) {
        for (JiraIssue issue : this.issues) {
            if (!issue.getKey().equals(issueID)) continue;
            return issue;
        }
        return null;
    }

    public void addIssues(Set<JiraIssue> issuesToBeSaved) {
        this.issues.addAll(issuesToBeSaved);
    }
}

