/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.versionparameter;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraVersionParameterValue
extends ParameterValue {
    private static final long serialVersionUID = 7715888375360839484L;
    private String version;

    @DataBoundConstructor
    public JiraVersionParameterValue(String name, String version) {
        super(name);
        if (version == null) {
            throw new IllegalArgumentException("Version cannot be null");
        }
        this.version = version;
    }

    public void buildEnvironment(Run<?, ?> run, EnvVars env) {
        env.put(this.getName(), this.getVersion());
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return name -> this.name.equals(name) ? this.getVersion() : null;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public Object getValue() {
        return this.getVersion();
    }

    public String toString() {
        return "(JiraVersionParameterValue) " + this.getName() + "='" + this.version + "'";
    }
}

