/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.versionparameter;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.domain.Version;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.versionparameter.JiraVersionParameterValue;
import hudson.plugins.jira.versionparameter.VersionComparator;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;

public class JiraVersionParameterDefinition
extends ParameterDefinition {
    private static final long serialVersionUID = 4232979892748310160L;
    private String projectKey;
    private boolean showReleased = false;
    private boolean showArchived = false;
    private boolean showUnreleased = false;
    private Pattern pattern = null;

    @DataBoundConstructor
    public JiraVersionParameterDefinition(String name, String description, String jiraProjectKey, String jiraReleasePattern, String jiraShowReleased, String jiraShowArchived, String jiraShowUnreleased) {
        super(name);
        this.setDescription(description);
        this.setJiraProjectKey(jiraProjectKey);
        this.setJiraReleasePattern(jiraReleasePattern);
        this.setJiraShowReleased(jiraShowReleased);
        this.setJiraShowArchived(jiraShowArchived);
        this.setShowUnreleased(jiraShowUnreleased);
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String[] values = req.getParameterValues(this.getName());
        if (values == null || values.length != 1) {
            return null;
        }
        return new JiraVersionParameterValue(this.getName(), values[0]);
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject formData) {
        JiraVersionParameterValue value = (JiraVersionParameterValue)((Object)req.bindJSON(JiraVersionParameterValue.class, formData));
        return value;
    }

    public ParameterValue createValue(CLICommand command, String value) throws IOException, InterruptedException {
        return new JiraVersionParameterValue(this.getName(), value);
    }

    public List<Result> getVersions() throws IOException, RestClientException {
        Job contextJob = (Job)Stapler.getCurrentRequest2().findAncestorObject(Job.class);
        JiraSite site = JiraSite.get(contextJob);
        if (site == null) {
            throw new IllegalStateException("Jira site needs to be configured in the project " + contextJob.getFullDisplayName());
        }
        JiraSession session = site.getSession((Item)contextJob);
        if (session == null) {
            throw new IllegalStateException("Remote access for Jira isn't configured in Jenkins");
        }
        return session.getVersions(this.projectKey).stream().sorted(VersionComparator.INSTANCE).filter(this::match).map(Result::new).collect(Collectors.toList());
    }

    private boolean match(Version version) {
        boolean showAllVersions;
        if (this.pattern != null && !this.pattern.matcher(version.getName()).matches()) {
            return false;
        }
        boolean isReleased = version.isReleased();
        boolean isArchived = version.isArchived();
        boolean bl = showAllVersions = !this.showReleased && !this.showUnreleased && !this.showArchived;
        if (showAllVersions) {
            return true;
        }
        if (this.showReleased && isReleased && !isArchived) {
            return true;
        }
        if (this.showArchived && isArchived) {
            return true;
        }
        return this.showUnreleased && !isReleased && !isArchived;
    }

    public String getJiraReleasePattern() {
        if (this.pattern == null) {
            return "";
        }
        return this.pattern.pattern();
    }

    public void setJiraReleasePattern(String pattern) {
        this.pattern = pattern == null || pattern.isEmpty() ? null : Pattern.compile(pattern);
    }

    public String getJiraProjectKey() {
        return this.projectKey;
    }

    public void setJiraProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getJiraShowReleased() {
        return Boolean.toString(this.showReleased);
    }

    public void setJiraShowReleased(String showReleased) {
        this.showReleased = Boolean.parseBoolean(showReleased);
    }

    public String getJiraShowArchived() {
        return Boolean.toString(this.showArchived);
    }

    public void setJiraShowArchived(String showArchived) {
        this.showArchived = Boolean.parseBoolean(showArchived);
    }

    public String getJiraShowUnreleased() {
        return Boolean.toString(this.showUnreleased);
    }

    public void setShowUnreleased(String jiraShowUnreleased) {
        this.showUnreleased = Boolean.parseBoolean(jiraShowUnreleased);
    }

    public static class Result {
        public final String name;
        public final Long id;

        public Result(Version version) {
            this.name = version.getName();
            this.id = version.getId();
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return Objects.equals(this.name, result.name) && Objects.equals(this.id, result.id);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.id);
        }
    }

    @Extension
    @Symbol(value={"jiraReleaseVersion"})
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Jira Release Version Parameter";
        }
    }
}

