/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.EnvVars;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.VersionCreator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class JiraVersionCreatorBuilder
extends Builder
implements SimpleBuildStep {
    private String jiraVersion;
    private String jiraProjectKey;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraVersionCreatorBuilder(String jiraVersion, String jiraProjectKey) {
        this.jiraVersion = jiraVersion;
        this.jiraProjectKey = jiraProjectKey;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public String getJiraVersion() {
        return this.jiraVersion;
    }

    public void setJiraVersion(String jiraVersion) {
        this.jiraVersion = jiraVersion;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public void perform(Run<?, ?> run, EnvVars env, TaskListener listener) {
        new VersionCreator().perform(run.getParent(), this.jiraVersion, this.jiraProjectKey, run, listener);
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public BuildStepDescriptor<Builder> getDescriptor() {
        return DESCRIPTOR;
    }

    @Symbol(value={"jiraCreateVersion"})
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            super(JiraVersionCreatorBuilder.class);
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public JiraVersionCreatorBuilder newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (JiraVersionCreatorBuilder)((Object)req.bindJSON(JiraVersionCreatorBuilder.class, formData));
        }

        public String getDisplayName() {
            return Messages.JiraVersionCreatorBuilder_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-version-create.html";
        }
    }
}

