/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.matrix.MatrixAggregatable;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixProject;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.Messages;
import hudson.plugins.jira.Updater;
import hudson.plugins.jira.selector.AbstractIssueSelector;
import hudson.plugins.jira.selector.DefaultIssueSelector;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraIssueUpdater
extends Recorder
implements MatrixAggregatable,
SimpleBuildStep {
    private AbstractIssueSelector issueSelector;
    private SCM scm;
    private List<String> labels;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraIssueUpdater(AbstractIssueSelector issueSelector, SCM scm, List<String> labels) {
        this.issueSelector = issueSelector;
        this.scm = scm;
        this.labels = labels != null ? labels : new ArrayList<String>();
    }

    public void perform(Run<?, ?> run, EnvVars env, TaskListener listener) throws InterruptedException, IOException {
        if (run instanceof MatrixRun) {
            return;
        }
        if (run instanceof AbstractBuild) {
            AbstractBuild abstractBuild = (AbstractBuild)run;
            Updater updater = new Updater(((AbstractProject)abstractBuild.getParent()).getScm(), this.labels);
            updater.perform(run, listener, this.getIssueSelector());
        } else if (this.scm != null) {
            Updater updater = new Updater(this.scm, this.labels);
            updater.perform(run, listener, this.getIssueSelector());
        } else {
            throw new IllegalArgumentException("Unsupported run type " + run.getClass().getName());
        }
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public DescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public AbstractIssueSelector getIssueSelector() {
        AbstractIssueSelector uis = this.issueSelector;
        if (uis == null) {
            uis = new DefaultIssueSelector();
        }
        this.issueSelector = uis;
        return this.issueSelector;
    }

    public SCM getScm() {
        return this.scm;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public MatrixAggregator createAggregator(MatrixBuild build, Launcher launcher, BuildListener listener) {
        return new MatrixAggregator(build, launcher, listener){

            public boolean endBuild() throws InterruptedException, IOException {
                PrintStream logger = this.listener.getLogger();
                logger.println("End of Matrix Build. Updating Jira.");
                Updater updater = new Updater(((MatrixProject)this.build.getParent()).getScm(), JiraIssueUpdater.this.labels);
                return updater.perform((Run<?, ?>)this.build, (TaskListener)this.listener, JiraIssueUpdater.this.getIssueSelector());
            }
        };
    }

    @Symbol(value={"jiraCommentIssues"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private DescriptorImpl() {
            super(JiraIssueUpdater.class);
        }

        public String getDisplayName() {
            return Messages.JiraIssueUpdater_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help.html";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public boolean hasIssueSelectors() {
            return Jenkins.getInstance().getDescriptorList(AbstractIssueSelector.class).size() > 1;
        }
    }
}

