/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class JiraIssueUpdateBuilder
extends Builder
implements SimpleBuildStep {
    private final String jqlSearch;
    private final String workflowActionName;
    private final String comment;

    @DataBoundConstructor
    public JiraIssueUpdateBuilder(String jqlSearch, String workflowActionName, String comment) {
        this.jqlSearch = Util.fixEmptyAndTrim((String)jqlSearch);
        this.workflowActionName = Util.fixEmptyAndTrim((String)workflowActionName);
        this.comment = Util.fixEmptyAndTrim((String)comment);
    }

    public String getJqlSearch() {
        return this.jqlSearch;
    }

    public String getWorkflowActionName() {
        return this.workflowActionName;
    }

    public String getComment() {
        return this.comment;
    }

    JiraSite getSiteForJob(Job<?, ?> job) {
        return JiraSite.get(job);
    }

    public void perform(Run<?, ?> run, EnvVars env, TaskListener listener) throws InterruptedException, IOException {
        String realComment = Util.fixEmptyAndTrim((String)env.expand(this.comment));
        String realJql = Util.fixEmptyAndTrim((String)env.expand(this.jqlSearch));
        String realWorkflowActionName = Util.fixEmptyAndTrim((String)env.expand(this.workflowActionName));
        JiraSite site = this.getSiteForJob(run.getParent());
        if (site == null) {
            listener.getLogger().println(Messages.NoJiraSite());
            run.setResult(Result.FAILURE);
            return;
        }
        if (StringUtils.isNotEmpty((String)realWorkflowActionName)) {
            listener.getLogger().println(Messages.JiraIssueUpdateBuilder_UpdatingWithAction(realWorkflowActionName));
        }
        listener.getLogger().println("[Jira] JQL: " + realJql);
        try {
            if (!site.progressMatchingIssues(realJql, realWorkflowActionName, realComment, listener.getLogger())) {
                listener.getLogger().println(Messages.JiraIssueUpdateBuilder_SomeIssuesFailed());
                run.setResult(Result.UNSTABLE);
            }
        }
        catch (RestClientException e) {
            listener.getLogger().println(e.getMessage());
            run.setResult(Result.FAILURE);
        }
    }

    public boolean requiresWorkspace() {
        return false;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    @Symbol(value={"jiraExecuteWorkflow"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public FormValidation doCheckJqlSearch(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.JiraIssueUpdateBuilder_NoJqlSearch());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckWorkflowActionName(@QueryParameter String value) {
            if (Util.fixNull((String)value).trim().length() == 0) {
                return FormValidation.warning((String)Messages.JiraIssueUpdateBuilder_NoWorkflowAction());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> klass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraIssueUpdateBuilder_DisplayName();
        }
    }
}

