/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSite;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.IOException;
import java.util.HashMap;
import jenkins.tasks.SimpleBuildWrapper;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class JiraCreateReleaseNotes
extends SimpleBuildWrapper {
    public static final String DEFAULT_FILTER = "status in (Resolved, Closed)";
    public static final String DEFAULT_ENVVAR_NAME = "RELEASE_NOTES";
    private String jiraEnvironmentVariable;
    private String jiraProjectKey;
    private String jiraRelease;
    private String jiraFilter;

    public JiraCreateReleaseNotes(String jiraProjectKey, String jiraRelease, String jiraEnvironmentVariable) {
        this(jiraProjectKey, jiraRelease, jiraEnvironmentVariable, DEFAULT_FILTER);
    }

    @DataBoundConstructor
    public JiraCreateReleaseNotes(String jiraProjectKey, String jiraRelease, String jiraEnvironmentVariable, String jiraFilter) {
        this.jiraRelease = jiraRelease;
        this.jiraProjectKey = jiraProjectKey;
        this.jiraEnvironmentVariable = StringUtils.defaultIfEmpty((String)jiraEnvironmentVariable, (String)DEFAULT_ENVVAR_NAME);
        this.jiraFilter = StringUtils.defaultIfEmpty((String)jiraFilter, (String)DEFAULT_FILTER);
    }

    public String getJiraEnvironmentVariable() {
        return this.jiraEnvironmentVariable;
    }

    public String getJiraFilter() {
        return this.jiraFilter;
    }

    public String getJiraProjectKey() {
        return this.jiraProjectKey;
    }

    public String getJiraRelease() {
        return this.jiraRelease;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public void setJiraEnvironmentVariable(String jiraEnvironmentVariable) {
        this.jiraEnvironmentVariable = jiraEnvironmentVariable;
    }

    public void setJiraFilter(String jiraFilter) {
        this.jiraFilter = jiraFilter;
    }

    public void setJiraProjectKey(String jiraProjectKey) {
        this.jiraProjectKey = jiraProjectKey;
    }

    public void setJiraRelease(String jiraRelease) {
        this.jiraRelease = jiraRelease;
    }

    JiraSite getSiteForProject(Job<?, ?> project) {
        return JiraSite.get(project);
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        String releaseNotes;
        block6: {
            JiraSite site = this.getSiteForProject(run.getParent());
            String realRelease = null;
            String realProjectKey = null;
            releaseNotes = "No Release Notes";
            String realFilter = DEFAULT_FILTER;
            try {
                realRelease = run.getEnvironment(listener).expand(this.jiraRelease);
                realProjectKey = run.getEnvironment(listener).expand(this.jiraProjectKey);
                realFilter = run.getEnvironment(listener).expand(this.jiraFilter);
                if (StringUtils.isEmpty((String)realRelease)) {
                    throw new IllegalArgumentException("No version specified");
                }
                if (StringUtils.isEmpty((String)realProjectKey)) {
                    throw new IllegalArgumentException("No project specified");
                }
                if (realRelease != null && !realRelease.isEmpty()) {
                    releaseNotes = site.getReleaseNotesForFixVersion(realProjectKey, realRelease, realFilter);
                } else {
                    listener.getLogger().printf("No release version found, skipping Release Notes generation%n", new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace(listener.fatalError("Unable to generate release notes for Jira version %s/%s: %s", new Object[]{realRelease, realProjectKey, e}));
                if (!(listener instanceof BuildListener)) break block6;
                ((BuildListener)listener).finished(Result.FAILURE);
            }
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        envMap.put(this.jiraEnvironmentVariable, releaseNotes);
        context.getEnv().putAll(envMap);
    }

    @Extension
    @Symbol(value={"jiraCreateReleaseNotes"})
    public static final class Descriptor
    extends BuildWrapperDescriptor {
        public String getDisplayName() {
            return "Generate Release Notes";
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }
    }
}

