/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira;

import com.atlassian.jira.rest.client.api.RestClientException;
import com.atlassian.jira.rest.client.api.StatusCategory;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueType;
import com.atlassian.jira.rest.client.api.domain.Priority;
import com.atlassian.jira.rest.client.api.domain.Status;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.plugins.jira.JiraSession;
import hudson.plugins.jira.JiraSite;
import hudson.plugins.jira.Messages;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;

public class JiraCreateIssueNotifier
extends Notifier {
    private static final Logger LOG = Logger.getLogger(JiraCreateIssueNotifier.class.getName());
    private String projectKey;
    private String testDescription;
    private String assignee;
    private String component;
    private Long typeId;
    private Long priorityId;
    private Integer actionIdOnSuccess;
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public JiraCreateIssueNotifier(String projectKey, String testDescription, String assignee, String component, Long typeId, Long priorityId, Integer actionIdOnSuccess) {
        if (projectKey == null) {
            throw new IllegalArgumentException("Project key cannot be null");
        }
        this.projectKey = projectKey;
        this.testDescription = testDescription;
        this.assignee = assignee;
        this.component = component;
        this.typeId = typeId;
        this.priorityId = priorityId;
        this.actionIdOnSuccess = actionIdOnSuccess;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public String getTestDescription() {
        return this.testDescription;
    }

    public void setTestDescription(String testDescription) {
        this.testDescription = testDescription;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public String getComponent() {
        return this.component;
    }

    public void setComponent(String component) {
        this.component = component;
    }

    public Long getTypeId() {
        return this.typeId;
    }

    public Long getPriorityId() {
        return this.priorityId;
    }

    public Integer getActionIdOnSuccess() {
        return this.actionIdOnSuccess;
    }

    public BuildStepDescriptor<Publisher> getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException {
        String jobDirPath = build.getProject().getBuildDir().getPath();
        String filename = jobDirPath + File.separator + "issue.txt";
        EnvVars vars = build.getEnvironment(TaskListener.NULL);
        Result currentBuildResult = build.getResult();
        Result previousBuildResult = null;
        AbstractBuild previousBuild = (AbstractBuild)build.getPreviousCompletedBuild();
        if (previousBuild != null) {
            previousBuildResult = previousBuild.getResult();
        }
        if (currentBuildResult != Result.ABORTED && previousBuild != null) {
            try {
                if (currentBuildResult == Result.FAILURE) {
                    this.currentBuildResultFailure(build, listener, previousBuildResult, filename, vars);
                }
                if (currentBuildResult == Result.SUCCESS) {
                    this.currentBuildResultSuccess(build, listener, previousBuildResult, filename, vars);
                }
            }
            catch (RestClientException e) {
                listener.getLogger().println(e.getMessage());
            }
        }
        return true;
    }

    private Issue createJiraIssue(AbstractBuild<?, ?> build, String filename) throws IOException, InterruptedException {
        Long priority;
        EnvVars vars = build.getEnvironment(TaskListener.NULL);
        JiraSession session = this.getJiraSession(build);
        String buildName = this.getBuildName(vars);
        String summary = String.format("Build %s failed", buildName);
        String description = String.format("%s%n%nThe build %s has failed.%nFirst failed run: %s", this.testDescription.equals("") ? "No description is provided" : vars.expand(this.testDescription), buildName, this.getBuildDetailsString(vars));
        Iterable components = Arrays.stream(this.component.split(",")).filter(s -> !StringUtils.isEmpty((String)s)).map(StringUtils::trim).collect(Collectors.toList());
        Long type = this.typeId;
        if (type == null || type == 0L) {
            LOG.info("Returning default issue type id 1");
            type = 1L;
        }
        if ((priority = this.priorityId) != null && priority == 0L) {
            priority = null;
        }
        Issue issue = session.createIssue(this.projectKey, description, this.assignee, components, summary, type, priority);
        this.writeInFile(filename, issue);
        return issue;
    }

    private Status getStatus(AbstractBuild<?, ?> build, String id) throws IOException {
        JiraSession session = this.getJiraSession(build);
        Issue issue = session.getIssueByKey(id);
        return issue.getStatus();
    }

    private void addComment(AbstractBuild<?, ?> build, BuildListener listener, String id, String comment) throws IOException {
        JiraSession session = this.getJiraSession(build);
        session.addCommentWithoutConstrains(id, comment);
        listener.getLogger().println(String.format("[%s] Commented issue", id));
    }

    private String getIssue(String filename) throws IOException, InterruptedException {
        String string;
        block10: {
            String issueId = "";
            Path path = Paths.get(filename, new String[0]);
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            BufferedReader br = Files.newBufferedReader(path);
            try {
                String issue;
                while ((issue = br.readLine()) != null) {
                    issueId = issue;
                }
                string = StringUtils.trimToNull((String)issueId);
                if (br == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    return null;
                }
            }
            br.close();
        }
        return string;
    }

    JiraSite getSiteForProject(AbstractProject<?, ?> project) {
        return JiraSite.get(project);
    }

    private JiraSession getJiraSession(AbstractBuild<?, ?> build) throws IOException {
        JiraSite site = this.getSiteForProject(build.getProject());
        if (site == null) {
            throw new IllegalStateException("Jira site needs to be configured in the project " + build.getFullDisplayName());
        }
        JiraSession session = site.getSession((Item)build.getProject());
        if (session == null) {
            throw new IllegalStateException("Remote access for Jira isn't configured in Jenkins");
        }
        return session;
    }

    private void deleteFile(String filename) {
        File file = new File(filename);
        if (file.exists() && !file.delete()) {
            LOG.warning("WARNING: couldn't delete file: " + filename);
        }
    }

    private void writeInFile(String filename, Issue issue) throws IOException {
        try (BufferedWriter bw = Files.newBufferedWriter(Paths.get(filename, new String[0]), new OpenOption[0]);){
            bw.write(issue.getKey() == null ? "null" : issue.getKey());
        }
    }

    private void currentBuildResultFailure(AbstractBuild<?, ?> build, BuildListener listener, Result previousBuildResult, String filename, EnvVars vars) throws InterruptedException, IOException, RestClientException {
        if (previousBuildResult == Result.FAILURE) {
            String comment = String.format("Build is still failing.%nFailed run: %s", this.getBuildDetailsString(vars));
            String issueId = this.getIssue(filename);
            if (issueId != null) {
                try {
                    Status status = this.getStatus(build, issueId);
                    if (JiraCreateIssueNotifier.isDone(status)) {
                        listener.getLogger().println("The previous build also failed but the issue is closed");
                        this.deleteFile(filename);
                        Issue issue = this.createJiraIssue(build, filename);
                        LOG.info(String.format("[%s] created.", issue.getKey()));
                        listener.getLogger().println("Build failed, created Jira issue " + issue.getKey());
                    } else {
                        this.addComment(build, listener, issueId, comment);
                        LOG.info(String.format("[%s] The previous build also failed, comment added.", issueId));
                    }
                }
                catch (IOException e) {
                    LOG.warning(String.format("[%s] - error processing Jira change: %s", issueId, e.getMessage()));
                }
            }
        }
        if (previousBuildResult == Result.SUCCESS || previousBuildResult == Result.ABORTED) {
            try {
                Issue issue = this.createJiraIssue(build, filename);
                LOG.info(String.format("[%s] created.", issue.getKey()));
                listener.getLogger().println("Build failed, created Jira issue " + issue.getKey());
            }
            catch (IOException e) {
                listener.error("Error creating Jira issue : " + e.getMessage());
                LOG.warning("Error creating Jira issue\n" + e.getMessage());
            }
        }
    }

    private void currentBuildResultSuccess(AbstractBuild<?, ?> build, BuildListener listener, Result previousBuildResult, String filename, EnvVars vars) throws InterruptedException, IOException {
        if (previousBuildResult == Result.FAILURE || previousBuildResult == Result.SUCCESS) {
            String comment = String.format("Previously failing build now is OK.%n Passed run: %s", this.getBuildDetailsString(vars));
            String issueId = this.getIssue(filename);
            if (issueId != null) {
                try {
                    Status status = this.getStatus(build, issueId);
                    if (JiraCreateIssueNotifier.isDone(status)) {
                        LOG.info(String.format("%s is closed", issueId));
                        this.deleteFile(filename);
                    } else {
                        LOG.info(String.format("%s is not closed, comment was added.", issueId));
                        this.addComment(build, listener, issueId, comment);
                        if (this.actionIdOnSuccess != null && this.actionIdOnSuccess > 0) {
                            this.progressWorkflowAction(build, issueId, this.actionIdOnSuccess);
                        }
                    }
                }
                catch (IOException e) {
                    listener.error("Error updating Jira issue " + issueId + " : " + e.getMessage());
                    LOG.warning("Error updating Jira issue " + issueId + "\n" + String.valueOf(e));
                }
            }
        }
    }

    static boolean isDone(Status status) {
        if (status.getName().equalsIgnoreCase(finishedStatuses.Closed.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Resolved.toString()) || status.getName().equalsIgnoreCase(finishedStatuses.Done.toString())) {
            return true;
        }
        StatusCategory category = status.getStatusCategory();
        if (category == null) {
            return false;
        }
        return "done".equals(category.getKey());
    }

    private void progressWorkflowAction(AbstractBuild<?, ?> build, String issueId, Integer actionId) throws IOException {
        JiraSession session = this.getJiraSession(build);
        session.progressWorkflowAction(issueId, actionId);
    }

    private String getBuildDetailsString(EnvVars vars) {
        String buildURL = (String)vars.get((Object)"BUILD_URL");
        return String.format("[%s|%s] [console log|%s]", this.getBuildName(vars), buildURL, buildURL.concat("console"));
    }

    private String getBuildName(EnvVars vars) {
        String jobName = (String)vars.get((Object)"JOB_NAME");
        String buildNumber = (String)vars.get((Object)"BUILD_NUMBER");
        return String.format("%s #%s", jobName, buildNumber);
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(JiraCreateIssueNotifier.class);
        }

        public FormValidation doCheckProjectKey(@QueryParameter String value) throws IOException {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please set the project key");
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillPriorityIdItems(@AncestorInPath Item item) {
            ListBoxModel items = new ListBoxModel().add("");
            List<JiraSite> sites = JiraSite.getJiraSites(item);
            for (JiraSite site : sites) {
                JiraSession session = site.getSession(item);
                if (session == null) continue;
                for (Priority priority : session.getPriorities()) {
                    items.add("[" + site.getName() + "] " + priority.getName(), String.valueOf(priority.getId()));
                }
            }
            return items;
        }

        public ListBoxModel doFillTypeIdItems(@AncestorInPath Item item) {
            ListBoxModel items = new ListBoxModel().add("");
            List<JiraSite> sites = JiraSite.getJiraSites(item);
            for (JiraSite site : sites) {
                JiraSession session = site.getSession(item);
                if (session == null) continue;
                for (IssueType type : session.getIssueTypes()) {
                    items.add("[" + site.getName() + "] " + type.getName(), String.valueOf(type.getId()));
                }
            }
            return items;
        }

        public JiraCreateIssueNotifier newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return (JiraCreateIssueNotifier)((Object)req.bindJSON(JiraCreateIssueNotifier.class, formData));
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JiraCreateIssueNotifier_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/jira/help-jira-create-issue.html";
        }
    }

    static enum finishedStatuses {
        Closed,
        Done,
        Resolved;

    }
}

