/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.util;

import hudson.EnvVars;
import java.io.IOException;
import java.io.PrintStream;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import retrofit2.Response;

public class Common {
    public static boolean empty(String str) {
        return str == null || str.trim().isEmpty();
    }

    public static String sanitizeURL(String url) {
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        return url;
    }

    public static void log(PrintStream logger, Object message) {
        if (logger != null) {
            logger.println(message);
        }
    }

    public static String getJobName(EnvVars envVars) {
        return (String)envVars.get((Object)"JOB_NAME");
    }

    public static String getBuildNumber(PrintStream logger, EnvVars envVars) {
        String answer = (String)envVars.get((Object)"BUILD_NUMBER");
        if (answer == null) {
            Common.log(logger, "No BUILD_NUMBER!");
            return "1";
        }
        return answer;
    }

    public static <T> ResponseData<T> parseResponse(Response<T> response) throws IOException {
        ResponseData.ResponseDataBuilder<Object> builder = ResponseData.builder();
        builder.successful(response.isSuccessful()).code(response.code()).message(response.message());
        if (!response.isSuccessful()) {
            String errorMessage = response.errorBody().string();
            builder.error(errorMessage);
        } else {
            builder.data(response.body());
        }
        return builder.build();
    }

    public static <T> ResponseData<T> buildErrorResponse(Exception e) {
        ResponseData.ResponseDataBuilder builder = ResponseData.builder();
        String errorMessage = Common.getRootCause(e).getMessage();
        return builder.successful(false).code(-1).error(errorMessage).build();
    }

    public static Throwable getRootCause(Throwable throwable) {
        if (throwable.getCause() != null) {
            return Common.getRootCause(throwable.getCause());
        }
        return throwable;
    }
}

