/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.InputStream;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class UploadAttachmentStep
extends BasicJiraStep {
    private static final long serialVersionUID = 2996407840986266627L;
    private final String idOrKey;
    private final String file;

    @DataBoundConstructor
    public UploadAttachmentStep(String idOrKey, String file) {
        this.idOrKey = idOrKey;
        this.file = file;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getIdOrKey() {
        return this.idOrKey;
    }

    @Generated
    public String getFile() {
        return this.file;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 7064983919695548462L;
        private final UploadAttachmentStep step;

        protected Execution(UploadAttachmentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            Object errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (idOrKey == null) {
                    errorMessage = "ID or key is null or empty";
                    return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
                }
                FilePath ws = (FilePath)this.getContext().get(FilePath.class);
                assert (ws != null);
                if (Util.fixEmpty((String)this.step.getFile()) == null) {
                    errorMessage = "file is null or empty";
                    return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
                }
                FilePath path = ws.child(this.step.getFile());
                if (!path.exists()) {
                    errorMessage = path.getRemote() + " does not exist.";
                    return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
                }
                if (path.isDirectory()) {
                    errorMessage = path.getRemote() + " is a directory.";
                    return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
                }
            }
            return response;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> responseData = this.verifyInput();
            if (responseData == null) {
                FilePath ws = (FilePath)this.getContext().get(FilePath.class);
                FilePath path = ws.child(this.step.getFile());
                this.logger.println("JIRA: Site - " + this.siteName + " - Attaching file: " + path.getRemote() + " to " + this.step.getIdOrKey());
                byte[] bytes = IOUtils.toByteArray((InputStream)path.read());
                responseData = this.jiraService.uploadAttachment(this.step.getIdOrKey(), path.getRemote(), bytes);
            }
            return this.logResponse(responseData);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraUploadAttachment";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Attach a file from workspace to an issue";
        }
    }
}

