/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class NotifyIssueStep
extends BasicJiraStep {
    private static final long serialVersionUID = -5286750553487650184L;
    private final String idOrKey;
    private final Object notify;

    @DataBoundConstructor
    public NotifyIssueStep(String idOrKey, Object notify) {
        this.idOrKey = idOrKey;
        this.notify = notify;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getIdOrKey() {
        return this.idOrKey;
    }

    @Generated
    public Object getNotify() {
        return this.notify;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = 2997765348391402484L;
        private final NotifyIssueStep step;

        protected Execution(NotifyIssueStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Notifing Issue: " + this.step.getIdOrKey());
                response = this.jiraService.notifyIssue(this.step.getIdOrKey(), this.step.getNotify());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                Object notify = this.step.getNotify();
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (notify == null) {
                    errorMessage = "notify is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraNotifyIssue";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Notify Issue";
        }
    }
}

