/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.InputBuilder;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class NewVersionStep
extends BasicJiraStep {
    private static final long serialVersionUID = -528328534268615694L;
    private final Object version;

    @DataBoundConstructor
    public NewVersionStep(Object version) {
        this.version = version;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public Object getVersion() {
        return this.version;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 7109283776054289821L;
        private final NewVersionStep step;

        protected Execution(NewVersionStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Creating new version: " + String.valueOf(this.step.getVersion()));
                if (this.step.isAuditLog()) {
                    String description = this.addMeta("");
                    InputBuilder.appendDescription(this.step.getVersion(), description);
                }
                response = this.jiraService.createVersion(this.step.getVersion());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            Object errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraNewVersion";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Create New Version";
        }
    }
}

