/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.api.input.IssueInput;
import org.thoughtslive.jenkins.plugins.jira.api.input.IssuesInput;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class NewIssuesStep
extends BasicJiraStep {
    private static final long serialVersionUID = -1390437007976428509L;
    private final IssuesInput issues;

    @DataBoundConstructor
    public NewIssuesStep(IssuesInput issues) {
        this.issues = issues;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public IssuesInput getIssues() {
        return this.issues;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -7395311395671768027L;
        private final NewIssuesStep step;

        protected Execution(NewIssuesStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Creating new Issues: " + String.valueOf(this.step.getIssues()));
                for (IssueInput issue : this.step.getIssues().getIssueUpdates()) {
                    if (issue.getFields().get("description") != null) {
                        String description = issue.getFields().get("description").toString();
                        description = this.step.isAuditLog() ? this.addPanelMeta(description) : description;
                        issue.getFields().put("description", description);
                        continue;
                    }
                    if (!this.step.isAuditLog()) continue;
                    issue.getFields().put("description", this.addPanelMeta(""));
                }
                response = this.jiraService.createIssues(this.step.getIssues());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                IssuesInput issues = this.step.getIssues();
                for (IssueInput issue : issues.getIssueUpdates()) {
                    if (issue == null) {
                        errorMessage = "issue is null.";
                        return Common.buildErrorResponse(new RuntimeException(errorMessage));
                    }
                    if (issue.getFields() == null) {
                        errorMessage = "fields is null.";
                        return Common.buildErrorResponse(new RuntimeException(errorMessage));
                    }
                    if (issue.getFields().get("summary") == null || Util.fixEmpty((String)issue.getFields().get("summary").toString()) == null) {
                        errorMessage = "fields->summary is empty or null.";
                    }
                    if (issue.getFields().get("issuetype") == null) {
                        errorMessage = "fields->issuetype is null.";
                        return Common.buildErrorResponse(new RuntimeException(errorMessage));
                    }
                    if (issue.getFields().get("project") == null) {
                        errorMessage = "fields->project is null.";
                        return Common.buildErrorResponse(new RuntimeException(errorMessage));
                    }
                    if (errorMessage == null) continue;
                    this.logger.println("The error here can be of from any of the issues. Please check all the issues.");
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                    break;
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraNewIssues";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Create New Issues";
        }
    }
}

