/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.api.input.IssueInput;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class NewIssueStep
extends BasicJiraStep {
    private static final long serialVersionUID = -3952881085849787165L;
    private final IssueInput issue;

    @DataBoundConstructor
    public NewIssueStep(IssueInput issue) {
        this.issue = issue;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public IssueInput getIssue() {
        return this.issue;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 2782781910330634547L;
        private final NewIssueStep step;

        protected Execution(NewIssueStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Creating new issue: " + String.valueOf(this.step.getIssue()));
                if (this.step.getIssue().getFields().get("description") != null) {
                    String description = this.step.getIssue().getFields().get("description").toString();
                    description = this.step.isAuditLog() ? this.addPanelMeta(description) : description;
                    this.step.getIssue().getFields().put("description", description);
                } else if (this.step.isAuditLog()) {
                    this.step.getIssue().getFields().put("description", this.addPanelMeta(""));
                }
                response = this.jiraService.createIssue(this.step.getIssue());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                IssueInput issue = this.step.getIssue();
                if (issue == null) {
                    errorMessage = "issue is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (issue.getFields() == null) {
                    errorMessage = "fields is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (issue.getFields().get("summary") == null || Util.fixEmpty((String)issue.getFields().get("summary").toString()) == null) {
                    errorMessage = "fields->summary is empty or null.";
                }
                if (issue.getFields().get("issuetype") == null) {
                    errorMessage = "fields->issuetype is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (issue.getFields().get("project") == null) {
                    errorMessage = "fields->project is null.";
                    return Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraNewIssue";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Create New Issue";
        }
    }
}

