/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class GetIssueWatchesStep
extends BasicJiraStep {
    private static final long serialVersionUID = -4095433082021536972L;
    private final String idOrKey;

    @DataBoundConstructor
    public GetIssueWatchesStep(String idOrKey) {
        this.idOrKey = idOrKey;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getIdOrKey() {
        return this.idOrKey;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -2511162263195215296L;
        private final GetIssueWatchesStep step;

        protected Execution(GetIssueWatchesStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Querying issue watches - idOrKey: " + this.step.getIdOrKey());
                response = this.jiraService.getIssueWatches(this.step.getIdOrKey());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraGetIssueWatches";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Get Issue Watches";
        }
    }
}

