/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class EditVersionStep
extends BasicJiraStep {
    private static final long serialVersionUID = -2029161404995143511L;
    private final String id;
    private final Object version;

    @DataBoundConstructor
    public EditVersionStep(String id, Object version) {
        this.id = id;
        this.version = version;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Object getVersion() {
        return this.version;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = -5317591315201131186L;
        private final EditVersionStep step;

        protected Execution(EditVersionStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Updating version: " + String.valueOf(this.step.getVersion()));
                response = this.jiraService.updateVersion(this.step.getId(), this.step.getVersion());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                if (this.step.getId() == null) {
                    errorMessage = "id is empty or null.";
                }
                if (this.step.getVersion() == null) {
                    errorMessage = "version is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraEditVersion";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Edit Version";
        }
    }
}

