/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class EditIssueStep
extends BasicJiraStep {
    private static final long serialVersionUID = -4542562652787306504L;
    private final String idOrKey;
    private final Object issue;

    @DataBoundConstructor
    public EditIssueStep(String idOrKey, Object issue) {
        this.idOrKey = idOrKey;
        this.issue = issue;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getIdOrKey() {
        return this.idOrKey;
    }

    @Generated
    public Object getIssue() {
        return this.issue;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -4127725325057889625L;
        private final EditIssueStep step;

        protected Execution(EditIssueStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Updating issue: " + this.step.getIdOrKey());
                response = this.jiraService.updateIssue(this.step.getIdOrKey(), this.step.getIssue(), this.step.getQueryParams());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                Object issue = this.step.getIssue();
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (issue == null) {
                    errorMessage = "issue is null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraEditIssue";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Edit Issue";
        }
    }
}

