/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.FilePath;
import hudson.Util;
import java.io.IOException;
import java.io.OutputStream;
import lombok.Generated;
import okhttp3.ResponseBody;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.InputBuilder;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class DownloadAttachmentStep
extends BasicJiraStep {
    private static final long serialVersionUID = 6317067114642701582L;
    private final String id;
    private final String file;
    private boolean override;

    @DataBoundConstructor
    public DownloadAttachmentStep(String id, String file, boolean override) {
        this.id = id;
        this.file = file;
        this.override = override;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public String getFile() {
        return this.file;
    }

    @Generated
    public boolean isOverride() {
        return this.override;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = -1459989930759928081L;
        private final DownloadAttachmentStep step;

        protected Execution(DownloadAttachmentStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            Object errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            String attachmentId = Util.fixEmpty((String)this.step.getId());
            if (response == null && attachmentId == null) {
                errorMessage = "id is null or empty";
                return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
            }
            FilePath ws = (FilePath)this.getContext().get(FilePath.class);
            assert (ws != null);
            if (Util.fixEmpty((String)this.step.getFile()) == null) {
                errorMessage = "file is null or empty";
                return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
            }
            FilePath path = ws.child(this.step.getFile());
            if (path.isDirectory()) {
                errorMessage = path.getRemote() + " is a directory.";
                return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
            }
            if (path.exists() && !this.step.override) {
                errorMessage = path.getRemote() + " already exist.";
                return Common.buildErrorResponse(new RuntimeException((String)errorMessage));
            }
            return response;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> responseData = this.verifyInput();
            if (responseData == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Downloading attachment with Id: " + this.step.getId());
                responseData = this.jiraService.getAttachment(this.step.getId());
                if (responseData.isSuccessful()) {
                    String attachmentLink = InputBuilder.getAttachmentLink(responseData.getData());
                    ResponseData<ResponseBody> response = this.jiraService.downloadAttachment(attachmentLink);
                    if (response.isSuccessful()) {
                        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
                        FilePath path = ws.child(this.step.getFile());
                        this.logger.println("JIRA: Site - " + this.siteName + " - Downloading " + attachmentLink + " file to: " + path.getRemote() + ", overriding an existing file?: " + this.step.override);
                        try (OutputStream os = path.write();){
                            os.write(response.getData().bytes());
                        }
                        catch (Exception e) {
                            responseData = Common.buildErrorResponse(e);
                        }
                        responseData.setData(null);
                    } else {
                        ResponseData.ResponseDataBuilder builder = ResponseData.builder();
                        builder.successful(response.isSuccessful()).code(response.getCode()).message(response.getMessage()).error(response.getError());
                        return builder.build();
                    }
                }
            }
            return this.logResponse(responseData);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraDownloadAttachment";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Download a file to workspace (directory is optional)";
        }
    }
}

