/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class AssignableUserSearchStep
extends BasicJiraStep {
    private static final long serialVersionUID = -7754102811625753132L;
    private String project;
    private String issueKey;
    @DataBoundSetter
    private String queryStr;
    @DataBoundSetter
    private int startAt = 0;
    @DataBoundSetter
    private int maxResults = 1000;

    @DataBoundConstructor
    public AssignableUserSearchStep(String project, String issueKey) {
        this.project = project;
        this.issueKey = issueKey;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getIssueKey() {
        return this.issueKey;
    }

    @Generated
    public String getQueryStr() {
        return this.queryStr;
    }

    @Generated
    public int getStartAt() {
        return this.startAt;
    }

    @Generated
    public int getMaxResults() {
        return this.maxResults;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Object>> {
        private static final long serialVersionUID = 3640953129479843111L;
        private final AssignableUserSearchStep step;

        protected Execution(AssignableUserSearchStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Object> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                this.logger.println("JIRA: Site - " + this.siteName + " - Searching assignable JIRA Users: " + this.step.getQueryStr() + " by project/issueKey: " + this.step.getProject() + " / " + this.step.getIssueKey() + " startAt: " + this.step.getStartAt() + " maxResults: " + this.step.getMaxResults());
                response = this.jiraService.assignableUserSearch(this.step.getQueryStr(), this.step.getProject(), this.step.getIssueKey(), this.step.getStartAt(), this.step.getMaxResults());
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String project = Util.fixEmpty((String)this.step.getProject());
                String issueKey = Util.fixEmpty((String)this.step.getIssueKey());
                if (project == null && issueKey == null) {
                    errorMessage = "either project or issueKey is required.";
                }
                if (this.step.getMaxResults() > 1000) {
                    errorMessage = "maxResults: The maximum allowed value is 1000.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraAssignableUserSearch";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Searches assignable JIRA Users by username, name or email address for the given project/issueKey";
        }
    }
}

