/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.steps;

import hudson.Extension;
import hudson.Util;
import java.io.IOException;
import lombok.Generated;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.steps.BasicJiraStep;
import org.thoughtslive.jenkins.plugins.jira.util.Common;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepDescriptorImpl;
import org.thoughtslive.jenkins.plugins.jira.util.JiraStepExecution;

public class AssignIssueStep
extends BasicJiraStep {
    private static final long serialVersionUID = -7552691123209663987L;
    private final String idOrKey;
    private final String userName;
    private final String accountId;

    @DataBoundConstructor
    public AssignIssueStep(String idOrKey, String userName, String accountId) {
        this.idOrKey = idOrKey;
        this.userName = userName;
        this.accountId = accountId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    @Generated
    public String getIdOrKey() {
        return this.idOrKey;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    public static class Execution
    extends JiraStepExecution<ResponseData<Void>> {
        private static final long serialVersionUID = -7608114889563811741L;
        private final AssignIssueStep step;

        protected Execution(AssignIssueStep step, StepContext context) throws IOException, InterruptedException {
            super(context);
            this.step = step;
        }

        protected ResponseData<Void> run() throws Exception {
            ResponseData<Object> response = this.verifyInput();
            if (response == null) {
                String userName = Util.fixEmpty((String)this.step.getUserName()) == null ? Util.fixEmpty((String)this.step.getAccountId()) : Util.fixEmpty((String)this.step.getUserName());
                this.logger.println("JIRA: Site - " + this.siteName + " - Assigning issue: " + this.step.getIdOrKey() + " to: " + userName);
                response = this.jiraService.assignIssue(this.step.getIdOrKey(), userName);
            }
            return this.logResponse(response);
        }

        @Override
        protected <T> ResponseData<T> verifyInput() throws Exception {
            String errorMessage = null;
            ResponseData response = this.verifyCommon(this.step);
            if (response == null) {
                String idOrKey = Util.fixEmpty((String)this.step.getIdOrKey());
                if (idOrKey == null) {
                    errorMessage = "idOrKey is empty or null.";
                }
                if (errorMessage != null) {
                    response = Common.buildErrorResponse(new RuntimeException(errorMessage));
                }
            }
            return response;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends JiraStepDescriptorImpl {
        public String getFunctionName() {
            return "jiraAssignIssue";
        }

        public String getDisplayName() {
            return this.getPrefix() + "Assign Issue";
        }
    }
}

