/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.service;

import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Part;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.QueryMap;
import retrofit2.http.Streaming;
import retrofit2.http.Url;

public interface JiraEndPoints {
    @GET(value="rest/api/2/serverInfo")
    public Call<Map<String, Object>> getServerInfo();

    @GET(value="rest/api/2/component/{id}")
    public Call<Object> getComponent(@Path(value="id") String var1);

    @POST(value="rest/api/2/component")
    public Call<Object> createComponent(@Body Object var1);

    @PUT(value="rest/api/2/component/{id}")
    public Call<Void> updateComponent(@Path(value="id") String var1, @Body Object var2);

    @GET(value="rest/api/2/component/{id}/relatedIssueCounts")
    public Call<Object> getComponentIssueCount(@Path(value="id") String var1);

    @GET(value="rest/api/2/issue/{issueIdOrKey}")
    public Call<Object> getIssue(@Path(value="issueIdOrKey") String var1, @QueryMap Map<String, String> var2);

    @POST(value="rest/api/2/issue")
    public Call<Object> createIssue(@Body Object var1);

    @PUT(value="rest/api/2/issue/{issueIdOrKey}")
    public Call<Object> updateIssue(@Path(value="issueIdOrKey") String var1, @Body Object var2, @QueryMap Map<String, String> var3);

    @POST(value="rest/api/2/issue/bulk")
    public Call<Object> createIssues(@Body Object var1);

    @PUT(value="rest/api/2/issue/{issueIdOrKey}/assignee")
    public Call<Void> assignIssue(@Path(value="issueIdOrKey") String var1, @Body Object var2);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/comment")
    public Call<Object> getComments(@Path(value="issueIdOrKey") String var1);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/comment")
    public Call<Object> addComment(@Path(value="issueIdOrKey") String var1, @Body Object var2);

    @PUT(value="rest/api/2/issue/{issueIdOrKey}/comment/{id}")
    public Call<Object> updateComment(@Path(value="issueIdOrKey") String var1, @Path(value="id") String var2, @Body Object var3);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/comment/{id}")
    public Call<Object> getComment(@Path(value="issueIdOrKey") String var1, @Path(value="id") String var2);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/notify")
    public Call<Void> notifyIssue(@Path(value="issueIdOrKey") String var1, @Body Object var2);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/transitions?expand=transitions.fields")
    public Call<Object> getTransitions(@Path(value="issueIdOrKey") String var1);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/transitions")
    public Call<Void> transitionIssue(@Path(value="issueIdOrKey") String var1, @Body Object var2);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/watchers")
    public Call<Object> getIssueWatches(@Path(value="issueIdOrKey") String var1);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/watchers")
    public Call<Void> addIssueWatcher(@Path(value="issueIdOrKey") String var1, @Body String var2);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/remotelink")
    public Call<Object> getIssueRemoteLinks(@Path(value="issueIdOrKey") String var1, @Query(value="globalId") String var2);

    @GET(value="rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}")
    public Call<Object> getIssueRemoteLink(@Path(value="issueIdOrKey") String var1, @Path(value="linkId") String var2);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/remotelink")
    public Call<Object> createIssueRemoteLink(@Path(value="issueIdOrKey") String var1, @Body Object var2);

    @POST(value="rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}")
    public Call<Object> updateIssueRemoteLink(@Path(value="issueIdOrKey") String var1, @Path(value="linkId") String var2, @Body Object var3);

    @DELETE(value="rest/api/2/issue/{issueIdOrKey}/remotelink")
    public Call<Object> deleteIssueRemoteLinks(@Path(value="issueIdOrKey") String var1, @Query(value="globalId") String var2);

    @DELETE(value="rest/api/2/issue/{issueIdOrKey}/remotelink/{linkId}")
    public Call<Object> deleteIssueRemoteLink(@Path(value="issueIdOrKey") String var1, @Path(value="linkId") String var2);

    @POST(value="rest/api/2/issueLink")
    public Call<Void> createIssueLink(@Body Object var1);

    @GET(value="rest/api/2/issueLink/{linkId}")
    public Call<Object> getIssueLink(@Path(value="linkId") String var1);

    @DELETE(value="rest/api/2/issueLink/{linkId}")
    public Call<Object> deleteIssueLink(@Path(value="linkId") String var1);

    @GET(value="rest/api/2/issueLinkType")
    public Call<Object> getIssueLinkTypes();

    @GET(value="rest/api/2/project?expand=lead,description")
    public Call<Object> getProjects();

    @GET(value="rest/api/2/project/{projectIdOrKey}")
    public Call<Object> getProject(@Path(value="projectIdOrKey") String var1);

    @GET(value="rest/api/2/project/{projectIdOrKey}/statuses")
    public Call<Object> getProjectStatuses(@Path(value="projectIdOrKey") String var1);

    @GET(value="rest/api/2/project/{projectIdOrKey}/components")
    public Call<Object> getProjectComponents(@Path(value="projectIdOrKey") String var1);

    @GET(value="rest/api/2/project/{projectIdOrKey}/versions")
    public Call<Object> getProjectVersions(@Path(value="projectIdOrKey") String var1);

    @POST(value="rest/api/2/search")
    public Call<Object> searchIssues(@Body Object var1);

    @POST(value="rest/api/3/search/jql")
    public Call<Object> searchIssuesV3(@Body Object var1);

    @POST(value="rest/api/2/version")
    public Call<Object> createVersion(@Body Object var1);

    @GET(value="rest/api/2/version/{id}")
    public Call<Object> getVersion(@Path(value="id") String var1);

    @PUT(value="rest/api/2/version/{id}")
    public Call<Void> updateVersion(@Path(value="id") String var1, @Body Object var2);

    @GET(value="rest/api/2/field")
    public Call<Object> getFields();

    @POST(value="rest/api/2/field")
    public Call<Object> createField(@Body Object var1);

    @GET(value="rest/api/2/user/search")
    public Call<Object> userSearch(@Query(value="username") String var1, @Query(value="startAt") int var2, @Query(value="maxResults") int var3);

    @GET(value="rest/api/2/user/assignable/search")
    public Call<Object> assignableUserSearch(@Query(value="username") String var1, @Query(value="project") String var2, @Query(value="issueKey") String var3, @Query(value="startAt") int var4, @Query(value="maxResults") int var5);

    @Multipart
    @Headers(value={"X-Atlassian-Token: no-check"})
    @POST(value="rest/api/2/issue/{issueIdOrKey}/attachments")
    public Call<Object> uploadAttachment(@Path(value="issueIdOrKey") String var1, @Part MultipartBody.Part var2);

    @GET(value="rest/api/2/attachment/{attachmentId}")
    public Call<Object> getAttachment(@Path(value="attachmentId") String var1);

    @DELETE(value="rest/api/2/attachment/{attachmentId}")
    public Call<Object> deleteAttachment(@Path(value="attachmentId") String var1);

    @Streaming
    @GET
    public Call<ResponseBody> downloadFileWithDynamicUrl(@Url String var1);
}

