/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira.login;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.ItemGroup;
import hudson.security.ACL;
import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import jenkins.model.Jenkins;
import oauth.signpost.exception.OAuthException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.acegisecurity.Authentication;
import org.thoughtslive.jenkins.plugins.jira.Messages;
import org.thoughtslive.jenkins.plugins.jira.Site;
import org.thoughtslive.jenkins.plugins.jira.login.OAuthConsumer;
import org.thoughtslive.jenkins.plugins.jira.login.RsaSha1MessageSigner;

@SuppressFBWarnings
public class SigningInterceptor
implements Interceptor {
    private final Site jiraSite;

    public SigningInterceptor(Site jiraSite) {
        this.jiraSite = jiraSite;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (Site.LoginType.BASIC.name().equalsIgnoreCase(this.jiraSite.getLoginType())) {
            String credentials = this.jiraSite.getUserName() + ":" + this.jiraSite.getPassword().getPlainText();
            String encodedHeader = "Basic " + new String(Base64.getEncoder().encode(credentials.getBytes()));
            Request requestWithAuthorization = chain.request().newBuilder().addHeader("Authorization", encodedHeader).build();
            return chain.proceed(requestWithAuthorization);
        }
        if (Site.LoginType.OAUTH.name().equalsIgnoreCase(this.jiraSite.getLoginType())) {
            Request request = chain.request();
            OAuthConsumer consumer = new OAuthConsumer(this.jiraSite.getConsumerKey(), this.jiraSite.getPrivateKeySecret().getPlainText());
            consumer.setTokenWithSecret(this.jiraSite.getToken().getPlainText(), this.jiraSite.getSecret().getPlainText());
            consumer.setMessageSigner(new RsaSha1MessageSigner());
            try {
                return chain.proceed((Request)consumer.sign(request).unwrap());
            }
            catch (OAuthException e) {
                throw new IOException("Error signing request with OAuth.", e);
            }
        }
        if (Site.LoginType.CREDENTIAL.name().equalsIgnoreCase(this.jiraSite.getLoginType())) {
            StandardUsernameCredentials credentialsId = null;
            credentialsId = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM, Collections.emptyList()).stream().filter(c -> c.getId().equals(this.jiraSite.getCredentialsId())).findFirst().orElseThrow(() -> new IllegalStateException(Messages.Site_invalidCredentialsId()));
            Object credentials = credentialsId.getUsername();
            if (credentialsId instanceof UsernamePasswordCredentials) {
                credentials = (String)credentials + ":" + ((UsernamePasswordCredentials)credentialsId).getPassword().getPlainText();
            }
            String encodedHeader = "Basic " + new String(Base64.getEncoder().encode(((String)credentials).getBytes()));
            Request requestWithAuthorization = chain.request().newBuilder().addHeader("Authorization", encodedHeader).build();
            return chain.proceed(requestWithAuthorization);
        }
        throw new IOException("Invalid Login Type, this isn't expected.");
    }
}

