/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import hudson.Extension;
import hudson.Util;
import hudson.diagnosis.OldDataMonitor;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.XStream2;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import lombok.Generated;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import org.thoughtslive.jenkins.plugins.jira.JiraStepsConfig;
import org.thoughtslive.jenkins.plugins.jira.Messages;
import org.thoughtslive.jenkins.plugins.jira.api.ResponseData;
import org.thoughtslive.jenkins.plugins.jira.service.JiraService;

public class Site
extends AbstractDescribableImpl<Site> {
    @Generated
    private static final Logger log = Logger.getLogger(Site.class.getName());
    private final String name;
    private final URL url;
    private final String loginType;
    private int timeout;
    private int readTimeout;
    private boolean useV3Search;
    private String userName;
    private Secret password;
    private String consumerKey;
    private transient String privateKey;
    private Secret privateKeySecret;
    private Secret secret;
    private Secret token;
    private String credentialsId;
    private transient JiraService jiraService = null;

    @DataBoundConstructor
    public Site(String name, URL url, String loginType, int timeout, boolean useV3Search) {
        this.name = Util.fixEmpty((String)name);
        this.url = url;
        this.loginType = Util.fixEmpty((String)loginType);
        this.timeout = timeout;
        this.useV3Search = useV3Search;
    }

    public static Site get(String siteName) {
        Site[] sites;
        for (Site site : sites = JiraStepsConfig.DESCRIPTOR.getSites()) {
            if (!site.getName().equalsIgnoreCase(siteName)) continue;
            return site;
        }
        return null;
    }

    public String isLoginType(String loginType) {
        return this.loginType.equalsIgnoreCase(loginType) ? "true" : "";
    }

    @DataBoundSetter
    public void setPassword(String password) {
        this.password = Secret.fromString((String)Util.fixEmpty((String)password));
    }

    @DataBoundSetter
    public void setSecret(String secret) {
        this.secret = Secret.fromString((String)Util.fixEmpty((String)secret));
    }

    @DataBoundSetter
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @DataBoundSetter
    public void setUseV3Search(boolean useV3Search) {
        this.useV3Search = useV3Search;
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = Secret.fromString((String)Util.fixEmpty((String)token));
    }

    @DataBoundSetter
    public void setPrivateKeySecret(String privateKey) {
        this.privateKeySecret = Secret.fromString((String)Util.fixEmpty((String)privateKey));
    }

    public JiraService getService() {
        if (this.jiraService == null) {
            this.jiraService = new JiraService(this);
        }
        return this.jiraService;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public URL getUrl() {
        return this.url;
    }

    @Generated
    public String getLoginType() {
        return this.loginType;
    }

    @Generated
    public int getTimeout() {
        return this.timeout;
    }

    @Generated
    public int getReadTimeout() {
        return this.readTimeout;
    }

    @Generated
    public boolean isUseV3Search() {
        return this.useV3Search;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @DataBoundSetter
    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public Secret getPassword() {
        return this.password;
    }

    @Generated
    public String getConsumerKey() {
        return this.consumerKey;
    }

    @DataBoundSetter
    @Generated
    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    @Generated
    public String getPrivateKey() {
        return this.privateKey;
    }

    @Generated
    public Secret getPrivateKeySecret() {
        return this.privateKeySecret;
    }

    @Generated
    public Secret getSecret() {
        return this.secret;
    }

    @Generated
    public Secret getToken() {
        return this.token;
    }

    @Generated
    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    @Generated
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Site> {
        public String getDisplayName() {
            return "JIRA Steps: Site";
        }

        public FormValidation doCheckName(@QueryParameter String name) {
            if (StringUtils.isBlank((String)name)) {
                return FormValidation.error((String)Messages.required());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            if (StringUtils.isBlank((String)url)) {
                return FormValidation.error((String)Messages.required());
            }
            try {
                new URL(url);
                return FormValidation.ok();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        public FormValidation doCheckTimeout(@QueryParameter Integer timeout) {
            if (timeout == null || timeout <= 100) {
                return FormValidation.error((String)Messages.Site_invalidTimeout());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckReadTimeout(@QueryParameter Integer readTimeout) {
            if (readTimeout == null || readTimeout <= 100) {
                return FormValidation.error((String)Messages.Site_invalidReadTimeout());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String url) {
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)credentialsId)) {
                return FormValidation.warning((String)Messages.Site_emptyCredentialsId());
            }
            List domainRequirements = URIRequirementBuilder.fromUri((String)url).build();
            if (CredentialsProvider.listCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)this.getAuthentication(item), (List)domainRequirements, (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId)).isEmpty()) {
                return FormValidation.error((String)Messages.Site_invalidCredentialsId());
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId, @QueryParameter String url) {
            StandardListBoxModel result = new StandardListBoxModel();
            credentialsId = StringUtils.trimToEmpty((String)credentialsId);
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            Authentication authentication = this.getAuthentication(item);
            List domainRequirements = URIRequirementBuilder.fromUri((String)url).build();
            CredentialsMatcher always = CredentialsMatchers.always();
            Class<UsernamePasswordCredentials> type = UsernamePasswordCredentials.class;
            result.includeEmptyValue();
            if (item != null) {
                result.includeMatchingAs(authentication, item, type, domainRequirements, always);
            } else {
                result.includeMatchingAs(authentication, (ItemGroup)Jenkins.get(), type, domainRequirements, always);
            }
            return result;
        }

        protected Authentication getAuthentication(Item item) {
            return item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM;
        }

        @POST
        public FormValidation doValidateCredentials(@QueryParameter String url, @QueryParameter String credentialsId, @QueryParameter Integer timeout, @QueryParameter Integer readTimeout, @QueryParameter Boolean useV3Search) throws IOException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.warning((String)"Insufficient permissions");
            }
            FormValidation validation = this.doCheckUrl(url);
            if (validation.kind != FormValidation.Kind.OK) {
                return FormValidation.error((String)Messages.Site_emptyURL());
            }
            validation = this.doCheckTimeout(timeout);
            if (validation.kind != FormValidation.Kind.OK) {
                return validation;
            }
            validation = this.doCheckReadTimeout(readTimeout);
            if (validation.kind != FormValidation.Kind.OK) {
                return validation;
            }
            Site site = new Site("test", new URL(url), LoginType.CREDENTIAL.name(), timeout, useV3Search);
            site.setCredentialsId(credentialsId);
            site.setReadTimeout(readTimeout);
            try {
                JiraService service = new JiraService(site);
                ResponseData<Map<String, Object>> response = service.getServerInfo();
                if (response.isSuccessful()) {
                    Map<String, Object> data = response.getData();
                    return FormValidation.ok((String)Messages.Site_testSuccess(data.get("serverTitle"), data.get("version")));
                }
                return FormValidation.error((String)response.getError());
            }
            catch (Exception e) {
                log.log(Level.WARNING, Messages.Site_testFail(url), e);
                return FormValidation.error((String)Messages.Site_testFail(url));
            }
        }

        @POST
        public FormValidation doValidateBasic(@QueryParameter String name, @QueryParameter String url, @QueryParameter String loginType, @QueryParameter String timeout, @QueryParameter String readTimeout, @QueryParameter Boolean useV3Search, @QueryParameter String userName, @QueryParameter String password, @QueryParameter String consumerKey, @QueryParameter String privateKey, @QueryParameter String secret, @QueryParameter String token) throws IOException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.warning((String)"Insufficient permissions");
            }
            url = Util.fixEmpty((String)url);
            name = Util.fixEmpty((String)name);
            userName = Util.fixEmpty((String)userName);
            password = Util.fixEmpty((String)password);
            URL mainURL = null;
            if (name == null) {
                return FormValidation.error((String)"Name is empty or null.");
            }
            try {
                if (url == null) {
                    return FormValidation.error((String)"No URL given.");
                }
                mainURL = new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            int t = 0;
            try {
                t = Integer.parseInt(timeout);
                if (t <= 100) {
                    return FormValidation.error((String)"Timeout can't be less than 100.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Timeout is not a number");
            }
            int rt = 0;
            try {
                rt = Integer.parseInt(readTimeout);
                if (rt <= 100) {
                    return FormValidation.error((String)"Read Timeout can't be less than 100.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Read Timeout is not a number");
            }
            Site site = new Site(name, mainURL, "BASIC", t, useV3Search);
            if (userName == null) {
                return FormValidation.error((String)"UserName is empty or null.");
            }
            if (password == null) {
                return FormValidation.error((String)"Password is empty or null.");
            }
            site.setUserName(userName);
            site.setPassword(password);
            site.setReadTimeout(rt);
            try {
                JiraService service = new JiraService(site);
                ResponseData<Map<String, Object>> response = service.getServerInfo();
                if (response.isSuccessful()) {
                    return FormValidation.ok((String)("Success: " + String.valueOf(response.getData().get("serverTitle")) + " - " + String.valueOf(response.getData().get("version"))));
                }
                return FormValidation.error((String)response.getError());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to Basic login to JIRA at " + url, e);
                return FormValidation.error((String)("Failed to Basic login to JIRA: " + url));
            }
        }

        @POST
        public FormValidation doValidateOAuth(@QueryParameter String name, @QueryParameter String url, @QueryParameter String loginType, @QueryParameter String timeout, @QueryParameter String readTimeout, @QueryParameter Boolean useV3Search, @QueryParameter String userName, @QueryParameter String password, @QueryParameter String consumerKey, @QueryParameter String privateKey, @QueryParameter String secret, @QueryParameter String token) throws IOException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.warning((String)"Insufficient permissions");
            }
            url = Util.fixEmpty((String)url);
            name = Util.fixEmpty((String)name);
            consumerKey = Util.fixEmpty((String)consumerKey);
            privateKey = Util.fixEmpty((String)privateKey);
            secret = Util.fixEmpty((String)secret);
            token = Util.fixEmpty((String)token);
            URL mainURL = null;
            if (name == null) {
                return FormValidation.error((String)"Name is empty.");
            }
            try {
                if (url == null) {
                    return FormValidation.error((String)"No URL given.");
                }
                mainURL = new URL(url);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)String.format("Malformed URL (%s)", url), (Object[])new Object[]{e});
            }
            int t = 0;
            try {
                t = Integer.parseInt(timeout);
                if (t <= 100) {
                    return FormValidation.error((String)"Timeout can't be less than 100.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Timeout is not a number");
            }
            int rt = 0;
            try {
                rt = Integer.parseInt(readTimeout);
                if (rt <= 100) {
                    return FormValidation.error((String)"Read Timeout can't be less than 100.");
                }
            }
            catch (NumberFormatException e) {
                return FormValidation.error((String)"Read Timeout is not a number");
            }
            Site site = new Site(name, mainURL, "OAUTH", t, useV3Search);
            if (consumerKey == null) {
                return FormValidation.error((String)"Consumer Key is empty or null.");
            }
            if (privateKey == null) {
                return FormValidation.error((String)"Private Key is empty or null.");
            }
            if (secret == null) {
                return FormValidation.error((String)"Secret is empty or null.");
            }
            if (token == null) {
                return FormValidation.error((String)"Token is empty or null.");
            }
            site.setConsumerKey(consumerKey);
            site.setPrivateKeySecret(privateKey);
            site.setSecret(secret);
            site.setToken(token);
            site.setReadTimeout(rt);
            try {
                JiraService service = new JiraService(site);
                ResponseData<Map<String, Object>> response = service.getServerInfo();
                if (response.isSuccessful()) {
                    return FormValidation.ok((String)("Success: " + String.valueOf(response.getData().get("serverTitle")) + " - " + String.valueOf(response.getData().get("version"))));
                }
                return FormValidation.error((String)response.getError());
            }
            catch (Exception e) {
                log.log(Level.WARNING, "Failed to OAuth login to JIRA at " + url, e);
                return FormValidation.error((String)("Failed to OAuth login to JIRA: " + url));
            }
        }
    }

    @Restricted(value={DoNotUse.class})
    public static class ConverterImpl
    extends XStream2.PassthruConverter<Site> {
        public ConverterImpl(XStream2 xstream) {
            super(xstream);
        }

        protected void callback(Site site, UnmarshallingContext context) {
            String privateKey = site.getPrivateKey();
            if (privateKey != null && !privateKey.isEmpty()) {
                site.setPrivateKeySecret(privateKey);
                OldDataMonitor.report((UnmarshallingContext)context, (String)"2.361.1");
            }
        }
    }

    public static enum LoginType {
        BASIC,
        OAUTH,
        CREDENTIAL;

    }
}

