/*
 * Decompiled with CFR 0.152.
 */
package org.thoughtslive.jenkins.plugins.jira;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.CopyOnWriteList;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.sf.json.JSONObject;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.thoughtslive.jenkins.plugins.jira.Site;

@SuppressFBWarnings
public class JiraStepsConfig
extends AbstractDescribableImpl<JiraStepsConfig> {
    @Extension
    public static final ConfigDescriptorImpl DESCRIPTOR = new ConfigDescriptorImpl();
    public final String siteName;

    @DataBoundConstructor
    public JiraStepsConfig(String siteName) {
        Site[] sites;
        if (siteName == null && (sites = DESCRIPTOR.getSites()).length > 0) {
            siteName = sites[0].getName();
        }
        this.siteName = siteName;
    }

    public Site getSite() {
        Site[] sites = DESCRIPTOR.getSites();
        if (this.siteName == null && sites.length > 0) {
            return sites[0];
        }
        for (Site site : sites) {
            if (!site.getName().equals(this.siteName)) continue;
            return site;
        }
        return null;
    }

    public ConfigDescriptorImpl getDescriptor() {
        return DESCRIPTOR;
    }

    public static final class ConfigDescriptorImpl
    extends Descriptor<JiraStepsConfig>
    implements Serializable {
        private static final long serialVersionUID = 6174559183832237318L;
        private final CopyOnWriteList<Site> sites = new CopyOnWriteList();

        public ConfigDescriptorImpl() {
            super(JiraStepsConfig.class);
            this.load();
        }

        public String getDisplayName() {
            return "JIRA Steps: JiraStepsConfig";
        }

        public Site[] getSites() {
            return (Site[])this.sites.toArray((Object[])new Site[0]);
        }

        public void setSites(Site[] newSites) {
            this.sites.replaceBy((Object[])newSites);
        }

        public JiraStepsConfig newInstance(@Nonnull StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            JiraStepsConfig jiraConfig = (JiraStepsConfig)((Object)req.bindJSON(JiraStepsConfig.class, formData));
            if (jiraConfig.siteName == null) {
                jiraConfig = null;
            }
            return jiraConfig;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) {
            Stapler.CONVERT_UTILS.deregister(URL.class);
            Stapler.CONVERT_UTILS.register((Converter)new EmptyFriendlyURLConverter(), URL.class);
            this.sites.replaceBy((Collection)req.bindJSONToList(Site.class, formData.get("sites")));
            this.save();
            return true;
        }

        @Restricted(value={NoExternalUse.class})
        public static class EmptyFriendlyURLConverter
        implements Converter {
            public Object convert(Class aClass, Object o) {
                if (o == null || "".equals(o) || "null".equals(o)) {
                    return null;
                }
                try {
                    return new URL(o.toString());
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
        }
    }
}

