/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.JobsContainer;
import org.marvelution.jji.model.parsers.BasicJobParser;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class JobsContainerParser<C extends JobsContainer>
implements MergingParser<C> {
    private static final String JOBS = "jobs";
    private static final String[] FIELDS = new String[]{"name", "fullName", "url"};
    private final BasicJobParser jobParser = new BasicJobParser();

    JobsContainerParser() {
    }

    @Override
    public boolean parse(JsonValue json, C target) {
        if (ParserUtils.isJsonObject(json)) {
            JsonObject object = json.asJsonObject();
            Optional<JsonArray> jobs = ParserUtils.optMember(JOBS, arg_0 -> ((JsonObject)object).getJsonArray(arg_0));
            if (jobs.isPresent()) {
                jobs.get().stream().map(element -> {
                    Job job = new Job().setSite(target.getSite());
                    if (this.jobParser.parse((JsonValue)element, job)) {
                        return job;
                    }
                    return null;
                }).filter(Objects::nonNull).forEach(arg_0 -> target.addJob(arg_0));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> fields() {
        return Collections.singletonList("jobs[" + String.join((CharSequence)",", FIELDS) + "]");
    }
}

