/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.parsers.BuildActionParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class CauseActionParser
extends BuildActionParser {
    private static final String CAUSES = "causes";
    private static final String SHORT_DESCRIPTION = "shortDescription";

    CauseActionParser() {
        super(null, CAUSES);
    }

    @Override
    protected void parse(JsonObject json, Build build) {
        json.getJsonArray(CAUSES).stream().filter(ParserUtils::isJsonObject).map(JsonValue::asJsonObject).map(cause -> ParserUtils.optString(cause, SHORT_DESCRIPTION)).filter(Optional::isPresent).map(Optional::get).findFirst().ifPresent(arg_0 -> ((Build)build).setCause(arg_0));
    }

    @Override
    public List<String> fields() {
        return Collections.singletonList("causes[shortDescription]");
    }
}

