/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import java.util.Set;
import java.util.stream.Collectors;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.parsers.BuildActionParser;

public class BuildGitBranchesParser
extends BuildActionParser {
    private static final String BUILDS_BY_BRANCH_NAME = "buildsByBranchName";

    public BuildGitBranchesParser() {
        super("hudson.plugins.git.util.BuildData", BUILDS_BY_BRANCH_NAME);
    }

    @Override
    protected void parse(JsonObject json, Build target) {
        Set branches = json.getJsonObject(BUILDS_BY_BRANCH_NAME).keySet().stream().map(branch -> {
            if (branch.startsWith("refs/")) {
                return branch.substring(branch.indexOf(47, 5) + 1);
            }
            return branch;
        }).collect(Collectors.toSet());
        target.getBranches().addAll(branches);
    }
}

