/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.ChangeSet;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class BuildChangeSetParser
implements MergingParser<Build> {
    private static final String[] COMMIT_ID_FIELDS = new String[]{"id", "node", "revision", "changeItem", "commitId"};
    private static final String[] COMMIT_MESSAGE_FIELDS = new String[]{"comment", "msg"};
    private static final String CHANGE_SETS = "changeSets";
    private static final String CHANGE_SET = "changeSet";
    private static final String ITEMS = "items";

    BuildChangeSetParser() {
    }

    @Override
    public boolean parse(JsonValue json, Build build) {
        if (ParserUtils.isJsonObject(json)) {
            JsonObject object = json.asJsonObject();
            Optional<JsonArray> changeSets = ParserUtils.optMember(CHANGE_SETS, arg_0 -> ((JsonObject)object).getJsonArray(arg_0));
            if (changeSets.isPresent()) {
                build.setChangeSet(changeSets.get().stream().map(this::parseChangeSet).flatMap(Collection::stream).collect(Collectors.toList()));
                return true;
            }
            if (object.containsKey((Object)CHANGE_SET)) {
                build.setChangeSet(this.parseChangeSet((JsonValue)object.get((Object)CHANGE_SET)));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> fields() {
        return Stream.of(CHANGE_SET, CHANGE_SETS).map(field -> field + "[*," + ITEMS + "[*]]").collect(Collectors.toList());
    }

    private List<ChangeSet> parseChangeSet(JsonValue json) {
        JsonArray changes = null;
        if (ParserUtils.isJsonObject(json) && json.asJsonObject().containsKey((Object)ITEMS)) {
            changes = json.asJsonObject().getJsonArray(ITEMS);
        } else if (ParserUtils.isJsonArray(json)) {
            changes = json.asJsonArray();
        }
        if (changes != null && changes.size() > 0) {
            return StreamSupport.stream(changes.spliterator(), false).filter(ParserUtils::isJsonObject).map(JsonValue::asJsonObject).map(object -> {
                Optional<String> commitId = ParserUtils.optString(object, COMMIT_ID_FIELDS);
                return ParserUtils.optString(object, COMMIT_MESSAGE_FIELDS).map(s -> StringUtils.stripEnd((String)s, (String)"\n")).map(s -> new ChangeSet().setCommitId((String)commitId.orElse(null)).setMessage(s)).orElse(null);
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return new ArrayList<ChangeSet>();
    }
}

