/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class BuildActionsParser
implements MergingParser<Build> {
    private static final String ACTIONS = "actions";
    private final MergingParser<Build> actionParserChain;

    BuildActionsParser(MergingParser<Build> actionParserChain) {
        this.actionParserChain = actionParserChain;
    }

    @Override
    public boolean parse(JsonValue json, Build build) {
        if (ParserUtils.isJsonObject(json)) {
            JsonObject object = json.asJsonObject();
            Optional<JsonArray> actions = ParserUtils.optMember(ACTIONS, arg_0 -> ((JsonObject)object).getJsonArray(arg_0));
            if (actions.isPresent()) {
                actions.get().forEach(action -> this.actionParserChain.parse((JsonValue)action, build));
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> fields() {
        return Collections.singletonList(ACTIONS + this.actionParserChain.fields().stream().collect(Collectors.joining(",", "[*,", "]")));
    }
}

