/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.trigger;

import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Job;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Queue;
import hudson.model.StringParameterValue;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.marvelution.jji.JiraUtils;
import org.marvelution.jji.security.SyncTokenSecurityContext;
import org.marvelution.jji.trigger.JiraCause;
import org.marvelution.jji.trigger.JiraIssueAction;

public class JiraBuildTriggerAction<JobT extends Job<JobT, ?>>
implements Action {
    static final String ISSUE_KEY = "issueKey";
    static final String ISSUE_URL = "issueUrl";
    static final String PARAMETERS = "parameters";
    static final String NAME = "name";
    private static final Logger LOGGER = Logger.getLogger(JiraBuildTriggerAction.class.getName());
    private final JobT target;

    public JiraBuildTriggerAction(JobT target) {
        this.target = target;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "jji";
    }

    @RequirePOST
    public void doBuild(StaplerRequest2 request, StaplerResponse2 response) throws IOException {
        SyncTokenSecurityContext.checkSyncTokenAuthentication((HttpServletRequest)request);
        if (this.target.isBuildable()) {
            ParametersDefinitionProperty parametersDefinitionProperty;
            ArrayList<Object> actions = new ArrayList<Object>();
            JSONObject data = JiraUtils.getJsonFromRequest(request);
            LOGGER.log(Level.INFO, "Received build trigger form Jira for {0}; {1}", new Object[]{this.target.getDisplayName(), data.toString()});
            String by = data.getString("by");
            String issueKey = data.optString(ISSUE_KEY, null);
            String issueUrl = data.optString(ISSUE_URL, null);
            actions.add(new CauseAction((Cause)new JiraCause(issueKey, by)));
            if (issueKey != null && issueUrl != null) {
                actions.add(new JiraIssueAction(issueUrl, issueKey));
            }
            if ((parametersDefinitionProperty = (ParametersDefinitionProperty)this.target.getProperty(ParametersDefinitionProperty.class)) != null) {
                JSONArray parameters;
                ParameterDefinition issueUrlParameter;
                ParameterDefinition issueKeyParameter;
                ArrayList<Object> parameterValues = new ArrayList<Object>();
                if (issueKey != null && (issueKeyParameter = this.getParameterDefinition(parametersDefinitionProperty, ISSUE_KEY, "issue_key")) != null) {
                    parameterValues.add(new StringParameterValue(issueKeyParameter.getName(), issueKey, issueKeyParameter.getDescription()));
                }
                if (issueUrl != null && (issueUrlParameter = this.getParameterDefinition(parametersDefinitionProperty, ISSUE_URL, "issue_url")) != null) {
                    parameterValues.add(new StringParameterValue(issueUrlParameter.getName(), issueUrl, issueUrlParameter.getDescription()));
                }
                if ((parameters = data.optJSONArray(PARAMETERS)) != null) {
                    LOGGER.log(Level.FINE, "Matching job parameters to values provided by Jira; {0}", parameters.toString());
                    for (Object object : parameters) {
                        JSONObject parameter = (JSONObject)object;
                        String name = parameter.getString(NAME);
                        ParameterDefinition parameterDefinition = this.getParameterDefinition(parametersDefinitionProperty, name);
                        if (parameterDefinition == null) continue;
                        parameter.element(NAME, (Object)parameterDefinition.getName());
                        ParameterValue parameterValue = parameterDefinition.createValue(request, parameter);
                        if (parameterValue != null) {
                            parameterValues.add(parameterValue);
                            continue;
                        }
                        parameterValue = parameterDefinition.getDefaultParameterValue();
                        if (parameterValue != null) {
                            parameterValues.add(parameterValue);
                            continue;
                        }
                        LOGGER.log(Level.WARNING, "Unable to match a value for parameter {0}. Jira didn't provide a value and the parameter definition has no default value.", parameterDefinition.getName());
                    }
                }
                actions.add(new ParametersAction(parameterValues));
            }
            Optional.ofNullable(Jenkins.getInstanceOrNull()).orElseThrow(() -> new IllegalStateException("No Jenkins instance found")).getQueue().schedule2((Queue.Task)this.target, 0, actions);
            response.setStatus(201);
        } else {
            response.setStatus(406);
        }
    }

    @Nullable
    private ParameterDefinition getParameterDefinition(ParametersDefinitionProperty parametersDefinitionProperty, String ... names) {
        LOGGER.log(Level.FINE, "Looking for a build parameter that matches: {0}", String.join((CharSequence)",", names));
        for (String name : names) {
            for (ParameterDefinition parameterDefinition : parametersDefinitionProperty.getParameterDefinitions()) {
                if (!parameterDefinition.getName().equalsIgnoreCase(name)) continue;
                LOGGER.log(Level.FINE, "Found build parameter {0} of type {1}", new Object[]{parameterDefinition.getName(), parameterDefinition.getType()});
                return parameterDefinition;
            }
        }
        LOGGER.log(Level.FINE, "No matching build parameter found");
        return null;
    }
}

