/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.marker;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.marvelution.jji.Messages;
import org.marvelution.jji.export.DeploymentEnvironmentAction;
import org.marvelution.jji.export.Environment;

public class DeploymentBuildMarker
extends Recorder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int ID_MAX_LENGTH = 40;
    private final String environmentId;
    private final String environmentName;
    private final Environment.Type environmentType;

    @DataBoundConstructor
    public DeploymentBuildMarker(String environmentId, String environmentName, String environmentType) {
        this.environmentType = Environment.Type.fromString(environmentType);
        this.environmentName = StringUtils.isNotBlank((CharSequence)environmentName) ? environmentName : this.environmentType.name();
        this.environmentId = StringUtils.isNotBlank((CharSequence)environmentId) ? (environmentId.length() > 40 ? DeploymentBuildMarker.generateId(environmentId) : environmentId) : DeploymentBuildMarker.generateId(this.environmentName);
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public String getEnvironmentType() {
        return this.environmentType.name();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) {
        this.perform((Run<?, ?>)build, (TaskListener)listener);
        return true;
    }

    public void perform(@NonNull Run<?, ?> build, @Nullable FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) {
        this.perform(build, listener);
    }

    private void perform(Run<?, ?> build, TaskListener listener) {
        Environment environment = new Environment(this.environmentId, this.environmentName, this.environmentType);
        listener.getLogger().format("Marking %s as deployment to %s", build, environment);
        build.addAction((Action)new DeploymentEnvironmentAction(environment));
    }

    private static String generateId(String environmentId) {
        return UUID.nameUUIDFromBytes(environmentId.getBytes(StandardCharsets.UTF_8)).toString();
    }

    @Extension
    public static class Descriptor
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Messages.deployment_build_marker();
        }

        public FormValidation doCheckEnvironmentId(@QueryParameter String value) {
            if (StringUtils.isNotBlank((CharSequence)value) && StringUtils.length((CharSequence)value.trim()) > 40) {
                return FormValidation.error((String)Messages.maximum_length(40));
            }
            if (StringUtils.containsWhitespace((CharSequence)value)) {
                return FormValidation.error((String)Messages.no_whitespaces_allowed());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckEnvironmentName(@QueryParameter String value) {
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.validateRequired((String)value);
            }
            if (StringUtils.length((CharSequence)value.trim()) > 255) {
                return FormValidation.error((String)Messages.maximum_length(255));
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillEnvironmentTypeItems() {
            ListBoxModel items = new ListBoxModel();
            for (Environment.Type type : Environment.Type.values()) {
                items.add(type.name());
            }
            return items;
        }
    }
}

