/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.management;

import hudson.Extension;
import hudson.model.ManagementLink;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import jenkins.model.Jenkins;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.bind.JavaScriptMethod;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.marvelution.jji.JiraUtils;
import org.marvelution.jji.Messages;
import org.marvelution.jji.configuration.JiraSite;
import org.marvelution.jji.configuration.JiraSitesConfiguration;
import org.marvelution.jji.rest.HttpClientProvider;
import org.marvelution.jji.security.SyncTokenSecurityContext;
import org.springframework.security.access.AccessDeniedException;

@Extension(ordinal=2.147483147E9)
public class JiraSiteManagement
extends ManagementLink {
    public static final String URL_NAME = "jji";
    private static final Logger LOGGER = Logger.getLogger(JiraSiteManagement.class.getName());
    private JiraSitesConfiguration sitesConfiguration;
    private JiraSite site;

    @Inject
    public void setSitesConfiguration(JiraSitesConfiguration sitesConfiguration) {
        this.sitesConfiguration = sitesConfiguration;
    }

    public String getIconFileName() {
        return "/plugin/jira-integration/images/48x48/jji.png";
    }

    public String getDescription() {
        return Messages.manage_description();
    }

    public String getUrlName() {
        return URL_NAME;
    }

    public ManagementLink.Category getCategory() {
        return ManagementLink.Category.CONFIGURATION;
    }

    public String getDisplayName() {
        return Messages.manage_display_name();
    }

    public boolean hasSites() {
        return !this.sitesConfiguration.getSites().isEmpty();
    }

    public Set<JiraSite> getSites() {
        return this.sitesConfiguration.stream().sorted(Comparator.comparing(JiraSite::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @JavaScriptMethod
    public void deleteSite(String uri) {
        this.sitesConfiguration.findSite(URI.create(uri)).ifPresent(site -> {
            OkHttpClient httpClient = HttpClientProvider.httpClient();
            try (Response response = httpClient.newCall(site.createUnregisterRequest()).execute();){
                if (response.isSuccessful()) {
                    LOGGER.info("Successfully unregistered site: " + String.valueOf(site));
                } else {
                    LOGGER.warning("Unable to unregistered site: " + String.valueOf(site) + ": Site responded with status " + response.code());
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to unregistered site: " + String.valueOf(site), e);
            }
            this.sitesConfiguration.unregisterSite((JiraSite)site);
        });
    }

    @JavaScriptMethod
    public String getSiteUrl(String url) {
        return this.sitesConfiguration.findSite(URI.create(url)).map(site -> {
            OkHttpClient httpClient = HttpClientProvider.httpClient();
            try (Response response = httpClient.newCall(site.createGetBaseUrlRequest()).execute();){
                String string;
                block14: {
                    ResponseBody body = response.body();
                    try {
                        string = body.string();
                        if (body == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (body != null) {
                            try {
                                body.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    body.close();
                }
                return string;
            }
            catch (Exception e) {
                return Messages.site_get_url_failed();
            }
        }).orElseGet(Messages::site_not_found);
    }

    public String getBaseHelpUrl() {
        return "/plugin/jira-integration/help/";
    }

    public void doIndex(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().getACL().checkPermission(Jenkins.ADMINISTER);
        if (req.hasParameter("url") && req.hasParameter("token")) {
            String url = req.getParameter("url");
            String token = req.getParameter("token");
            try {
                this.registerSiteForm(req, rsp, token, url);
            }
            catch (Exception e) {
                req.setAttribute("error", (Object)e.getMessage());
                req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
            }
        } else {
            req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    @RequirePOST
    public synchronized void doAdd(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().getACL().checkPermission(Jenkins.ADMINISTER);
        JSONObject form = req.getSubmittedForm();
        try {
            if (!form.containsKey((Object)"url")) {
                throw new IllegalArgumentException("Missing url");
            }
            String urlParam = form.getString("url");
            HttpUrl httpUrl = HttpUrl.parse((String)urlParam);
            if (httpUrl == null) {
                throw new IllegalArgumentException("Invalid URL " + urlParam);
            }
            String url = Objects.requireNonNull(httpUrl.queryParameter("url"), "Missing url parameter");
            String token = Objects.requireNonNull(httpUrl.queryParameter("token"), "Missing token parameter");
            this.registerSiteForm(req, rsp, token, url);
        }
        catch (Exception e) {
            req.setAttribute("error", (Object)e.getMessage());
            req.getView((Object)this, "manual").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    private void registerSiteForm(StaplerRequest2 req, StaplerResponse2 rsp, String token, String url) throws IOException, ServletException {
        block16: {
            OkHttpClient httpClient = HttpClientProvider.httpClient();
            try (Response response = httpClient.newCall(new Request.Builder().get().addHeader("X-Sync-Token", token).addHeader("X-JJI-Sync-Token", token).url(url).build()).execute();){
                if (response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        if (body != null) {
                            JSONObject details = JSONObject.fromObject((Object)body.string());
                            this.site = JiraSite.getSite(details);
                            req.getView((Object)this, "add").forward((ServletRequest)req, (ServletResponse)rsp);
                        }
                        break block16;
                    }
                    catch (JSONException e) {
                        throw new IllegalArgumentException("Invalid JSON response: " + e.getMessage());
                    }
                }
                throw new IllegalArgumentException("Unable to get registration details; " + response.code() + "[" + response.message() + "]");
            }
        }
    }

    public JiraSite getSite() {
        return this.site;
    }

    @RequirePOST
    public synchronized void doSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().getACL().checkPermission(Jenkins.ADMINISTER);
        JSONObject form = req.getSubmittedForm();
        try {
            JiraSite site = JiraSite.getSite(form);
            OkHttpClient httpClient = HttpClientProvider.httpClient();
            try (Response response = httpClient.newCall(site.createRegisterRequest()).execute();){
                if (response.code() != 202) {
                    throw new IllegalStateException("Failed to complete the registration with " + String.valueOf(site) + "; " + response.code() + "[" + response.message() + "]");
                }
            }
            this.sitesConfiguration.registerSite(site);
            rsp.sendRedirect(".");
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Registration of Jira site failed", e);
            req.setAttribute("error", (Object)e.getMessage());
            req.getView((Object)this, "index").forward((ServletRequest)req, (ServletResponse)rsp);
        }
    }

    @RequirePOST
    public synchronized void doRefresh(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        Jenkins.get().getACL().checkPermission(Jenkins.ADMINISTER);
        OkHttpClient httpClient = HttpClientProvider.httpClient();
        this.sitesConfiguration.updateSiteRegistrations(httpClient);
        rsp.sendRedirect(".");
    }

    @RequirePOST
    public void doRegister(StaplerRequest2 request) throws IOException {
        SyncTokenSecurityContext securityContext = SyncTokenSecurityContext.checkSyncTokenAuthentication((HttpServletRequest)request);
        Jenkins.get().getACL().checkPermission(Jenkins.ADMINISTER);
        JSONObject data = JiraUtils.getJsonFromRequest(request);
        JiraSite jiraSite = JiraSite.getSite(data);
        JiraSite existingSite = securityContext.getSite();
        if (existingSite != null && Objects.equals(jiraSite.getIdentifier(), existingSite.getIdentifier()) && Objects.equals(jiraSite.getSharedSecret(), existingSite.getSharedSecret())) {
            this.sitesConfiguration.registerSite(jiraSite);
        } else if (Objects.equals(jiraSite.getIdentifier(), securityContext.getClaimsSet().getIssuer())) {
            this.sitesConfiguration.registerSite(jiraSite);
        } else {
            throw new AccessDeniedException("Unauthorized Jira site registration attempt.");
        }
    }

    @RequirePOST
    public void doUnregister(StaplerRequest2 request) throws IOException {
        SyncTokenSecurityContext.checkSyncTokenAuthentication((HttpServletRequest)request);
        URI url = URI.create(JiraUtils.getJsonFromRequest(request).getString("url"));
        this.sitesConfiguration.findSite(url).ifPresent(this.sitesConfiguration::unregisterSite);
    }
}

