/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.listener;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.listeners.ItemListener;
import javax.inject.Inject;
import org.marvelution.jji.JiraUtils;
import org.marvelution.jji.SitesClient;
import org.marvelution.jji.events.JobNotificationType;

@Extension
public class JobListener
extends ItemListener {
    private SitesClient client;

    @Inject
    public void setClient(SitesClient client) {
        this.client = client;
    }

    public void onCreated(Item item) {
        this.client.notifyJobCreated(item);
    }

    public void onDeleted(Item item) {
        this.client.notifyJobDeleted(item);
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
        String jobHash = JiraUtils.getJobHash(item);
        new Thread(() -> this.client.notifyJobMoved(jobHash, item)).start();
    }

    public void onUpdated(Item item) {
        this.client.notifyJobModified(item, JobNotificationType.JOB_MODIFIED);
    }
}

