/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji;

import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.PluginServletFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.marvelution.jji.JiraIntegrationPlugin;

public class VersionHeaderFilter
implements Filter {
    private static final Logger LOGGER = Logger.getLogger(VersionHeaderFilter.class.getName());

    @Initializer(after=InitMilestone.PLUGINS_STARTED)
    public static void registerFilter() {
        VersionHeaderFilter filter = new VersionHeaderFilter();
        if (!PluginServletFilter.hasFilter((Filter)filter)) {
            try {
                PluginServletFilter.addFilter((Filter)filter);
            }
            catch (ServletException e) {
                LOGGER.log(Level.WARNING, "Failed to set up version header servlet filter", e);
            }
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            ((HttpServletResponse)response).setHeader("X-JiraIntegration", JiraIntegrationPlugin.getVersion());
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

