/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji;

import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.export.ExportConfig;
import org.kohsuke.stapler.export.Flavor;
import org.kohsuke.stapler.export.Model;
import org.kohsuke.stapler.export.ModelBuilder;
import org.kohsuke.stapler.export.NamedPathPruner;
import org.kohsuke.stapler.export.TreePruner;

public class JiraUtils {
    private static final ModelBuilder MODEL_BUILDER = new ModelBuilder();

    public static String getJobHash(Run run) {
        return JiraUtils.getJobHash((Item)run.getParent());
    }

    public static String getJobHash(Item item) {
        return JiraUtils.getJobHash(item.getUrl());
    }

    public static String getJobHash(String item) {
        String url = StringUtils.stripStart((String)StringUtils.stripEnd((String)item, (String)"/"), (String)"/");
        if (url.startsWith("job/")) {
            url = url.substring(4);
        }
        return DigestUtils.sha1Hex((String)url);
    }

    public static JSONObject getJsonFromRequest(StaplerRequest2 request) throws IOException {
        return JSONObject.fromObject((Object)IOUtils.toString((Reader)request.getReader()));
    }

    public static List<String> getAllParentHashes(Run run) {
        ArrayList<String> hashes = new ArrayList<String>();
        Job parent = run.getParent();
        while (parent instanceof Item) {
            hashes.add(JiraUtils.getJobHash((Item)parent));
            parent = ((Item)parent).getParent();
        }
        return hashes;
    }

    public static <T> String asJson(T item, List<String> fields) {
        try {
            StringWriter writer = new StringWriter();
            Model model = MODEL_BUILDER.get(item.getClass());
            Object pruner = fields.isEmpty() ? new TreePruner.ByDepth(1) : new NamedPathPruner(String.join((CharSequence)",", fields));
            model.writeTo(item, (TreePruner)pruner, Flavor.JSON.createDataWriter(item, (Writer)writer, new ExportConfig()));
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

