/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import com.atlassian.connect.spring.internal.jwt.AbstractJwtReader;
import com.atlassian.connect.spring.internal.jwt.JwtInvalidSigningAlgorithmException;
import com.atlassian.connect.spring.internal.jwt.JwtParseException;
import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.text.ParseException;
import java.util.Base64;

public class RsaJwtReader
extends AbstractJwtReader {
    private static Algorithm supportedAlgorithm = JWSAlgorithm.RS256;
    public static final String BEGIN = "-----BEGIN PUBLIC KEY-----";
    public static final String END = "-----END PUBLIC KEY-----";

    public static String getKeyIdAndCheckSigningAlgorithm(String jwt) throws JwtInvalidSigningAlgorithmException, JwtParseException {
        JWSObject jwsObject;
        try {
            jwsObject = JWSObject.parse((String)jwt);
        }
        catch (ParseException e) {
            throw new JwtParseException(e);
        }
        JWSAlgorithm algorithm = jwsObject.getHeader().getAlgorithm();
        if (!supportedAlgorithm.equals((Object)algorithm)) {
            throw new JwtInvalidSigningAlgorithmException(String.format("Expected JWT to be signed with '%s' but it was signed with '%s' instead", supportedAlgorithm, algorithm));
        }
        return jwsObject.getHeader().getKeyID();
    }

    @Override
    protected Algorithm getSupportedAlgorithm() {
        return supportedAlgorithm;
    }

    private static RSAPublicKey fromPEMEncodedKey(String pemEncodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String base64 = pemEncodedKey.replace(BEGIN, "").replace(END, "").replaceAll("\\R", "");
        byte[] bytes = Base64.getDecoder().decode(base64);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        return (RSAPublicKey)keyFactory.generatePublic(keySpec);
    }

    public RsaJwtReader(String pemEncodedKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        this(RsaJwtReader.fromPEMEncodedKey(pemEncodedKey));
    }

    public RsaJwtReader(RSAPublicKey key) {
        super((JWSVerifier)new RSASSAVerifier(key));
    }
}

