/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connect.spring.internal.jwt;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minidev.json.JSONObject;

public class JwtJsonBuilder {
    private static final Duration DEFAULT_JWT_LIFETIME = Duration.of(180L, ChronoUnit.SECONDS);
    private final JSONObject json = new JSONObject();

    public JwtJsonBuilder() {
        this(DEFAULT_JWT_LIFETIME);
    }

    public JwtJsonBuilder(Duration expireAfter) {
        long issuedAt = System.currentTimeMillis() / 1000L;
        this.issuedAt(issuedAt);
        this.expirationTime(issuedAt + expireAfter.getSeconds());
    }

    public JwtJsonBuilder audience(String aud) {
        this.json.put((Object)"aud", (Object)aud);
        return this;
    }

    public JwtJsonBuilder expirationTime(long exp) {
        this.json.put((Object)"exp", (Object)exp);
        return this;
    }

    public boolean isClaimSet(String name) {
        return this.json.containsKey((Object)name);
    }

    public JwtJsonBuilder issuedAt(long iat) {
        this.json.put((Object)"iat", (Object)iat);
        return this;
    }

    public JwtJsonBuilder issuer(String iss) {
        this.json.put((Object)"iss", (Object)iss);
        return this;
    }

    public JwtJsonBuilder jwtId(String jti) {
        this.json.put((Object)"jti", (Object)jti);
        return this;
    }

    public JwtJsonBuilder notBefore(long nbf) {
        this.json.put((Object)"nbf", (Object)nbf);
        return this;
    }

    public JwtJsonBuilder subject(String sub) {
        this.json.put((Object)"sub", (Object)sub);
        return this;
    }

    public JwtJsonBuilder type(String typ) {
        this.json.put((Object)"typ", (Object)typ);
        return this;
    }

    public JwtJsonBuilder queryHash(String qsh) {
        this.json.put((Object)"qsh", (Object)qsh);
        return this;
    }

    public JwtJsonBuilder claim(String name, Object obj) {
        Object current = this.json.get((Object)name);
        this.json.put((Object)name, this.merge(name, current, obj));
        return this;
    }

    public String build() {
        return this.json.toString();
    }

    public String toString() {
        return this.json.toString();
    }

    private Object merge(String name, Object first, Object second) {
        if (first instanceof List && second instanceof List) {
            ArrayList merged = new ArrayList((List)first);
            merged.addAll((List)second);
            return merged;
        }
        if (first instanceof Map && second instanceof Map) {
            HashMap merged = new HashMap((Map)first);
            Set entries = ((Map)second).entrySet();
            for (Map.Entry entry : entries) {
                merged.put(entry.getKey(), this.merge(name + "." + entry.getKey(), merged.get(entry.getKey()), entry.getValue()));
            }
            return merged;
        }
        if (first != null && second != null && !first.equals(second)) {
            throw new IllegalStateException("Cannot set claim '" + name + "' to '" + second + "'; it's already set as '" + first + "'");
        }
        return second == null ? first : second;
    }
}

