/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.utils;

import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.Site;
import org.marvelution.jji.model.SiteAuthentication;
import org.marvelution.jji.utils.spring.UriUtils;

public final class SiteUrl {
    private static final String API_JSON = "api/json/";
    private static final String SLASH = "/";
    private static final String QUESTIONMARK = "?";
    private static final String HASHTAG = "#";
    private static final String UTF_8 = "UTF-8";
    private final Function<Site, URI> baseUrlExtractor;
    private Site site = null;
    private SiteAuthentication authentication = null;
    private Job job = null;
    private Build build = null;
    private String path = null;
    private String query = null;
    private String fragment = null;
    private boolean nullable;

    public SiteUrl(Function<Site, URI> baseUrlExtractor) {
        this.baseUrlExtractor = baseUrlExtractor;
    }

    public static SiteUrl syncUrl() {
        return new SiteUrl(Site::getRpcUrl);
    }

    public static SiteUrl displayUrl() {
        return new SiteUrl(Site::getDisplayUrl);
    }

    public SiteUrl nullable() {
        this.nullable = true;
        return this;
    }

    public SiteUrl site(Site site) {
        this.site = site;
        return this;
    }

    public Site site() {
        this.check();
        return this.site;
    }

    public SiteUrl auth(SiteAuthentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public SiteAuthentication auth() {
        return Optional.ofNullable(this.authentication).orElseGet(this.site()::getAuthentication);
    }

    public SiteUrl job(Job job) {
        this.job = job;
        return this;
    }

    public Optional<Job> job() {
        this.check();
        return Optional.ofNullable(this.job);
    }

    public SiteUrl build(Build build) {
        this.build = build;
        return this;
    }

    public Optional<Build> build() {
        this.check();
        return Optional.ofNullable(this.build);
    }

    public SiteUrl path(String path) {
        this.path = StringUtils.stripStart((String)path, (String)SLASH);
        return this;
    }

    public Optional<String> path() {
        return Optional.ofNullable(this.path);
    }

    public SiteUrl query(String query) {
        this.query = this.query != null ? this.query + "&" + query : StringUtils.stripStart((String)query, (String)QUESTIONMARK);
        return this;
    }

    public SiteUrl query(String key, String value) {
        return this.query(key + "=" + value);
    }

    public Optional<String> query() {
        return Optional.ofNullable(this.query);
    }

    public SiteUrl fragment(String fragment) {
        this.fragment = StringUtils.stripStart((String)fragment, (String)HASHTAG);
        return this;
    }

    public Optional<String> fragment() {
        return Optional.ofNullable(this.fragment);
    }

    public SiteUrl api() {
        this.path = this.path != null ? StringUtils.stripEnd((String)this.path, (String)SLASH) + SLASH + API_JSON : API_JSON;
        return this;
    }

    public URI url() {
        try {
            return this.generate();
        }
        catch (IllegalStateException e) {
            if (this.nullable) {
                return null;
            }
            throw e;
        }
    }

    @Nonnull
    private URI generate() {
        this.check();
        String baseUrl = this.baseUrlExtractor.apply(this.site).toASCIIString();
        if (!baseUrl.endsWith(SLASH)) {
            baseUrl = baseUrl + SLASH;
        }
        StringBuilder urlBuilder = new StringBuilder(baseUrl);
        if (this.job != null) {
            String urlName = this.job.getUrlNameOrNull();
            if (StringUtils.isBlank((CharSequence)urlName)) {
                urlName = UriUtils.encodePath(this.job.getName(), UTF_8);
            }
            urlBuilder.append("job").append(SLASH).append(urlName).append(SLASH);
        }
        if (this.build != null) {
            urlBuilder.append(this.build.getNumber()).append(SLASH);
        }
        if (this.path != null) {
            urlBuilder.append(UriUtils.encodePath(this.path, UTF_8));
        }
        if (this.query != null) {
            urlBuilder.append(QUESTIONMARK).append(UriUtils.encodeQuery(this.query, UTF_8));
        }
        if (this.fragment != null) {
            urlBuilder.append(HASHTAG).append(UriUtils.encodeFragment(this.fragment, UTF_8));
        }
        return URI.create(urlBuilder.toString());
    }

    private void check() {
        Optional.ofNullable(this.build).ifPresent(build -> {
            if (!this.check(this.job, build::getJob)) {
                throw new IllegalStateException("missing or invalid job");
            }
            this.job = build.getJob();
        });
        Optional.ofNullable(this.job).ifPresent(job -> {
            if (!this.check(this.site, job::getSite)) {
                throw new IllegalStateException("missing or invalid site");
            }
            this.site = job.getSite();
        });
        Optional.ofNullable(this.site).orElseThrow(() -> new IllegalStateException("missing site"));
    }

    private <T> boolean check(T checked, Supplier<T> checker) {
        T t = checker.get();
        return !(checked == null && t == null || checked != null && !Objects.equals(checked, t));
    }

    public String toString() {
        return new StringJoiner(", ", SiteUrl.class.getSimpleName() + "[", "]").add("build=" + this.build).add("job=" + this.job).add("site=" + this.site).add("path='" + this.path + "'").add("query='" + this.query + "'").add("fragment='" + this.fragment + "'").toString();
    }
}

