/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import org.marvelution.jji.model.SiteAuthenticationType;

public abstract class SiteAuthentication {
    private final SiteAuthenticationType type;

    protected SiteAuthentication(SiteAuthenticationType type) {
        this.type = type;
    }

    public SiteAuthenticationType getType() {
        return this.type;
    }

    public static class SyncTokenSiteAuthentication
    extends SiteAuthentication {
        public SyncTokenSiteAuthentication() {
            super(SiteAuthenticationType.TOKEN);
        }
    }

    public static class BasicSiteAuthentication
    extends SiteAuthentication {
        private final String user;
        private final String token;

        public BasicSiteAuthentication(String user, String token) {
            super(SiteAuthenticationType.BASIC);
            this.user = user;
            this.token = token;
        }

        public String getUser() {
            return this.user;
        }

        public String getToken() {
            return this.token;
        }
    }
}

