/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.json.bind.annotation.JsonbCreator;
import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbTransient;
import java.io.Serializable;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;

@Immutable
public final class OperationId
implements Serializable,
Comparable<OperationId> {
    private static final Pattern PARTS_PATTERN = Pattern.compile("^(([^-]*)-([^-]*))-.*$");
    private final String id;
    private final String prefix;

    private OperationId(String id, String prefix) {
        this.id = Objects.requireNonNull(id);
        this.prefix = Objects.requireNonNull(prefix);
    }

    public static OperationId of(String id) {
        Matcher partsMatchers = PARTS_PATTERN.matcher(id);
        if (partsMatchers.matches()) {
            return new OperationId(id, partsMatchers.group(1));
        }
        throw new IllegalArgumentException("Invalid id, doesn't match " + PARTS_PATTERN.pattern());
    }

    @JsonbCreator
    public static OperationId of(@JsonbProperty String prefix, @JsonbProperty String id) {
        if (id.startsWith(prefix)) {
            return new OperationId(id, prefix);
        }
        return new OperationId(StringUtils.stripEnd((String)prefix, (String)"-") + "-" + id, prefix);
    }

    public String getId() {
        return this.id;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @JsonbTransient
    public String getUnprefixedId() {
        return this.id.substring(this.prefix.length() + 1);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationId that = (OperationId)o;
        return Objects.equals(this.id, that.id);
    }

    public String toString() {
        return this.id;
    }

    @Override
    public int compareTo(@Nonnull OperationId other) {
        return this.id.compareTo(other.id);
    }
}

