/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model;

import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.net.URI;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.marvelution.jji.model.ChangeSet;
import org.marvelution.jji.model.DeploymentEnvironment;
import org.marvelution.jji.model.HasId;
import org.marvelution.jji.model.IssueReference;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.OperationId;
import org.marvelution.jji.model.Result;
import org.marvelution.jji.model.Site;
import org.marvelution.jji.model.Syncable;
import org.marvelution.jji.model.TestResults;
import org.marvelution.jji.utils.SiteUrl;

@XmlRootElement
@XmlAccessorType(value=jakarta.xml.bind.annotation.XmlAccessType.FIELD)
@javax.xml.bind.annotation.XmlRootElement
@javax.xml.bind.annotation.XmlAccessorType(value=XmlAccessType.FIELD)
public class Build
implements HasId<Build>,
Syncable<Build> {
    public static final String OPERATION_PREFIX = "build-sync";
    private String id;
    private Job job;
    private int number;
    private String displayName;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private URI displayUrl;
    private String description;
    private boolean deleted;
    private String cause;
    private boolean building;
    private Result result;
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    private String builtOn;
    private long duration;
    private long timestamp;
    private Set<String> branches;
    private List<ChangeSet> changeSet;
    private TestResults testResults;
    private List<DeploymentEnvironment> deploymentEnvironments;
    private Set<IssueReference> issueReferences;

    @Override
    public Build copy() {
        Build build = new Build();
        build.id = this.id;
        if (this.job != null) {
            build.job = this.job.copy();
        }
        build.number = this.number;
        build.displayName = this.displayName;
        build.description = this.description;
        build.deleted = this.deleted;
        build.cause = this.cause;
        build.building = this.building;
        build.result = this.result;
        build.builtOn = this.builtOn;
        build.duration = this.duration;
        build.timestamp = this.timestamp;
        if (this.branches != null) {
            build.branches = new HashSet<String>(this.branches);
        }
        if (this.changeSet != null) {
            build.changeSet = this.changeSet.stream().map(change -> new ChangeSet().setCommitId(change.getCommitId()).setMessage(change.getMessage())).collect(Collectors.toList());
        }
        if (this.testResults != null) {
            build.testResults = new TestResults().setFailed(this.testResults.getFailed()).setSkipped(this.testResults.getSkipped()).setTotal(this.testResults.getTotal());
        }
        if (this.deploymentEnvironments != null) {
            build.deploymentEnvironments = this.deploymentEnvironments.stream().map(DeploymentEnvironment::copy).collect(Collectors.toList());
        }
        return build;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Build setId(String id) {
        this.id = id;
        return this;
    }

    public Job getJob() {
        return this.job;
    }

    public Build setJob(Job job) {
        this.job = job;
        return this;
    }

    public int getNumber() {
        return this.number;
    }

    public Build setNumber(int number) {
        this.number = number;
        return this;
    }

    public String getDisplayNumber() {
        return "#" + this.getNumber();
    }

    @Override
    public String getDisplayName() {
        return Optional.ofNullable(this.displayName).orElseGet(() -> {
            if (this.job == null) {
                return this.getDisplayNumber();
            }
            return this.getJob().getDisplayName() + " " + this.getDisplayNumber();
        });
    }

    public Build setDisplayName(@Nullable String displayName) {
        this.displayName = (String)StringUtils.defaultIfBlank((CharSequence)displayName, null);
        return this;
    }

    @Override
    @jakarta.xml.bind.annotation.XmlTransient
    @XmlTransient
    public Site getSite() {
        return this.job.getSite();
    }

    @Override
    public OperationId getOperationId() {
        return OperationId.of(OPERATION_PREFIX, this.job.getId() + "-" + this.number);
    }

    @Override
    public boolean isEnabled() {
        return this.job.isEnabled();
    }

    @Nullable
    public String getDisplayNameOrNull() {
        return this.displayName;
    }

    public String getShortDisplayName() {
        return Optional.ofNullable(this.displayName).orElseGet(this::getDisplayNumber);
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public URI getDisplayUrl() {
        if (this.displayUrl == null) {
            this.displayUrl = SiteUrl.displayUrl().build(this).nullable().url();
        }
        return this.displayUrl;
    }

    public Build setDisplayUrl(@Nullable URI displayUrl) {
        this.displayUrl = displayUrl;
        return this;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public Build setDescription(@Nullable String description) {
        this.description = (String)StringUtils.defaultIfBlank((CharSequence)description, null);
        return this;
    }

    public boolean isDeleted() {
        return this.deleted || this.job.isDeleted();
    }

    public Build setDeleted(boolean deleted) {
        this.deleted = deleted;
        return this;
    }

    @Nullable
    public String getCause() {
        return this.cause;
    }

    public Build setCause(@Nullable String cause) {
        this.cause = StringUtils.defaultString((String)cause, null);
        return this;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public Build setBuilding(boolean building) {
        this.building = building;
        return this;
    }

    public Result getResult() {
        return this.result;
    }

    public Build setResult(Result result) {
        this.result = result;
        return this;
    }

    @jakarta.xml.bind.annotation.XmlElement
    @XmlElement
    public String getBuiltOn() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.builtOn, (CharSequence)"master");
    }

    public Build setBuiltOn(@Nullable String builtOn) {
        this.builtOn = builtOn;
        return this;
    }

    @Nullable
    public String getBuiltOnOrNull() {
        if (StringUtils.isNotBlank((CharSequence)this.builtOn)) {
            return this.builtOn;
        }
        return null;
    }

    public long getDuration() {
        return this.duration;
    }

    public Build setDuration(@Nullable Long duration) {
        this.duration = duration != null ? duration : 0L;
        return this;
    }

    public String getFormattedDuration() {
        return Duration.ofMillis(this.duration).toString().substring(2).replaceAll("(\\d[HMS])(?!$)", "$1 ").toLowerCase();
    }

    public Date getBuildDate() {
        return new Date(this.timestamp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Build setTimestamp(@Nullable Long timestamp) {
        this.timestamp = timestamp != null ? timestamp : 0L;
        return this;
    }

    public Set<String> getBranches() {
        if (this.branches == null) {
            this.branches = new HashSet<String>();
        }
        return this.branches;
    }

    public Build setBranches(@Nullable Set<String> branches) {
        this.branches = branches;
        return this;
    }

    public List<ChangeSet> getChangeSet() {
        if (this.changeSet == null) {
            this.changeSet = new ArrayList<ChangeSet>();
        }
        return this.changeSet;
    }

    public Build setChangeSet(@Nullable List<ChangeSet> changeSet) {
        if (changeSet != null) {
            this.changeSet = new ArrayList<ChangeSet>(changeSet.size());
            this.changeSet.addAll(changeSet);
        } else {
            this.changeSet = null;
        }
        return this;
    }

    @Nullable
    public TestResults getTestResults() {
        return this.testResults;
    }

    public Build setTestResults(@Nullable TestResults testResults) {
        this.testResults = testResults;
        return this;
    }

    public List<DeploymentEnvironment> getDeploymentEnvironments() {
        if (this.deploymentEnvironments == null) {
            this.deploymentEnvironments = new ArrayList<DeploymentEnvironment>();
        }
        return this.deploymentEnvironments;
    }

    public Build setDeploymentEnvironments(List<DeploymentEnvironment> deploymentEnvironments) {
        this.deploymentEnvironments = new ArrayList<DeploymentEnvironment>(deploymentEnvironments);
        return this;
    }

    public Set<IssueReference> getIssueReferences() {
        if (this.issueReferences == null) {
            this.issueReferences = new HashSet<IssueReference>();
        }
        return this.issueReferences;
    }

    public Build setIssueReferences(Collection<IssueReference> issueReferences) {
        this.issueReferences = issueReferences != null ? new HashSet<IssueReference>(issueReferences) : new HashSet<IssueReference>();
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.job, this.number);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Build build = (Build)o;
        return Objects.equals(this.id, build.id) && Objects.equals(this.job, build.job) && this.number == build.number;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("id", (Object)this.id).append("jobId", (Object)this.job.getId()).append("number", this.number).append("cause", (Object)this.cause).append("result", (Object)this.result).append("timestamp", this.timestamp).append("deleted", this.deleted).toString();
    }
}

