/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class IssueLinksDeletedEvent {
    private final String projectKey;
    private final Set<String> issueKeys;

    public IssueLinksDeletedEvent(String projectKey, String ... issueKeys) {
        this(projectKey, Stream.of(issueKeys).collect(Collectors.toSet()));
    }

    @JsonCreator
    public IssueLinksDeletedEvent(@JsonProperty(value="projectKey") String projectKey, @JsonProperty(value="issueKeys") Set<String> issueKeys) {
        this.projectKey = projectKey;
        this.issueKeys = issueKeys;
    }

    @Nullable
    public String getProjectKey() {
        return this.projectKey;
    }

    @Nullable
    public Set<String> getIssueKeys() {
        return this.issueKeys;
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.issueKeys);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueLinksDeletedEvent that = (IssueLinksDeletedEvent)o;
        return Objects.equals(this.projectKey, that.projectKey) && this.issueKeys.equals(that.issueKeys);
    }

    public String toString() {
        return new StringJoiner(", ", IssueLinksDeletedEvent.class.getSimpleName() + "[", "]").add("projectKey='" + this.projectKey + "'").add("issueKeys=" + this.issueKeys).toString();
    }
}

