/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;

class ParserUtils {
    ParserUtils() {
    }

    static boolean isJsonObject(JsonValue json) {
        return json.getValueType() == JsonValue.ValueType.OBJECT;
    }

    static boolean isJsonArray(JsonValue json) {
        return json.getValueType() == JsonValue.ValueType.ARRAY;
    }

    static Stream<JsonValue> stream(JsonArray json) {
        return json != null ? json.stream() : Stream.empty();
    }

    static Optional<String> optString(JsonObject json, String member) {
        return ParserUtils.optMember(member, arg_0 -> ((JsonObject)json).getString(arg_0));
    }

    static Optional<String> optString(JsonObject json, String ... members) {
        return Arrays.stream(members).map(member -> ParserUtils.optString(json, member)).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    static Optional<Long> optLong(JsonObject json, String member) {
        return ParserUtils.optMember(member, arg_0 -> ((JsonObject)json).getJsonNumber(arg_0)).map(JsonNumber::longValue);
    }

    static Optional<Integer> optInt(JsonObject json, String member) {
        return ParserUtils.optMember(member, arg_0 -> ((JsonObject)json).getInt(arg_0));
    }

    static Optional<Boolean> optBoolean(JsonObject json, String member) {
        return ParserUtils.optMember(member, arg_0 -> ((JsonObject)json).getBoolean(arg_0));
    }

    static <T> Optional<T> optMember(String member, Function<String, T> accessor) {
        try {
            return Optional.of(accessor.apply(member));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

