/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import javax.annotation.Nullable;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

abstract class BuildActionParser
implements MergingParser<Build> {
    protected final String[] requiredFields;
    protected final String requireClass;

    protected BuildActionParser(@Nullable String requireClass, String ... requiredFields) {
        this.requireClass = requireClass;
        this.requiredFields = requiredFields;
    }

    @Override
    public boolean parse(JsonValue json, Build target) {
        if (ParserUtils.isJsonObject(json) && this.shouldParse(json.asJsonObject())) {
            this.parse(json.asJsonObject(), target);
            return true;
        }
        return this.handleMisMatch(json, target);
    }

    protected abstract void parse(JsonObject var1, Build var2);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean shouldParse(JsonObject json) {
        if (this.requiredFields != null) {
            for (String field : this.requiredFields) {
                if (json.containsKey((Object)field)) continue;
                return false;
            }
        }
        if (this.requireClass == null) return true;
        if (!ParserUtils.optString(json, "_class").filter(this.requireClass::equals).isPresent()) return false;
        return true;
    }

    protected boolean handleMisMatch(JsonValue json, Build target) {
        return false;
    }
}

