/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.Job;
import org.marvelution.jji.model.parsers.BasicBuildParser;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class BasicJobParser
implements MergingParser<Job> {
    public static final String NAME = "name";
    public static final String FULL_NAME = "fullName";
    public static final String URL = "url";
    public static final String DISPLAY_NAME = "displayName";
    public static final String DESCRIPTION = "description";
    public static final String FIRST_BUILD = "firstBuild";
    public static final String LAST_BUILD = "lastBuild";
    public static final String BUILDS = "builds";
    private final BasicBuildParser buildParser = new BasicBuildParser();

    BasicJobParser() {
    }

    @Override
    public boolean parse(JsonValue json, Job job) {
        if (ParserUtils.isJsonObject(json)) {
            if (job.shouldBeLinked()) {
                job.setLinked(true);
            }
            JsonObject object = json.asJsonObject();
            ParserUtils.optString(object, NAME).ifPresent(arg_0 -> ((Job)job).setName(arg_0));
            ParserUtils.optString(object, FULL_NAME).filter(name -> name.contains("/")).map(name -> name.substring(0, name.lastIndexOf("/"))).ifPresent(arg_0 -> ((Job)job).setParentName(arg_0));
            ParserUtils.optString(object, URL).map(url -> StringUtils.stripEnd((String)url, (String)"/")).map(url -> url.substring(url.indexOf("/job/") + 5)).filter(url -> !Objects.equals(job.getName(), url)).ifPresent(arg_0 -> ((Job)job).setUrlName(arg_0));
            ParserUtils.optString(object, DISPLAY_NAME).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((Job)job).setDisplayName(arg_0));
            ParserUtils.optString(object, DESCRIPTION).filter(StringUtils::isNotBlank).ifPresent(arg_0 -> ((Job)job).setDescription(arg_0));
            Optional.ofNullable(object.get((Object)FIRST_BUILD)).map(element -> this.parseBuild((JsonValue)element, job)).map(Build::getNumber).ifPresent(arg_0 -> ((Job)job).setOldestBuild(arg_0));
            Optional.ofNullable(object.get((Object)LAST_BUILD)).map(element -> this.parseBuild((JsonValue)element, job)).map(Build::getNumber).ifPresent(arg_0 -> ((Job)job).setLastBuild(arg_0));
            job.setBuilds(ParserUtils.stream(object.getJsonArray(BUILDS)).map(element -> this.parseBuild((JsonValue)element, job)).filter(Objects::nonNull).collect(Collectors.toList()));
            return true;
        }
        return false;
    }

    @Override
    public List<String> fields() {
        return Arrays.asList(NAME, FULL_NAME, URL, DISPLAY_NAME, DESCRIPTION, "firstBuild[number]", "lastBuild[number]", "builds[" + String.join((CharSequence)",", "number", "result") + "]");
    }

    @Nullable
    private Build parseBuild(JsonValue element, Job job) {
        Build build = new Build().setJob(job);
        if (this.buildParser.parse(element, build)) {
            return build;
        }
        return null;
    }
}

