/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.model.parsers;

import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.marvelution.jji.model.Build;
import org.marvelution.jji.model.Result;
import org.marvelution.jji.model.parsers.MergingParser;
import org.marvelution.jji.model.parsers.ParserUtils;

class BasicBuildParser
implements MergingParser<Build> {
    public static final String NUMBER = "number";
    public static final String DISPLAY_NAME = "displayName";
    public static final String FULL_DISPLAY_NAME = "fullDisplayName";
    public static final String DESCRIPTION = "description";
    public static final String BUILT_ON = "builtOn";
    public static final String RESULT = "result";
    public static final String BUILDING = "building";
    public static final String TIMESTAMP = "timestamp";
    public static final String DURATION = "duration";

    BasicBuildParser() {
    }

    @Override
    public boolean parse(JsonValue json, Build build) {
        if (ParserUtils.isJsonObject(json)) {
            JsonObject object = json.asJsonObject();
            ParserUtils.optInt(object, NUMBER).ifPresent(arg_0 -> ((Build)build).setNumber(arg_0));
            Optional<String> displayName = ParserUtils.optString(object, DISPLAY_NAME).filter(name -> !name.equals("#" + build.getNumber()));
            if (!displayName.isPresent() && build.getJob() != null) {
                displayName = ParserUtils.optString(object, FULL_DISPLAY_NAME).filter(name -> !name.endsWith(String.format("%s #%d", build.getJob().getName(), build.getNumber())));
            }
            displayName.ifPresent(arg_0 -> ((Build)build).setDisplayName(arg_0));
            ParserUtils.optString(object, DESCRIPTION).ifPresent(arg_0 -> ((Build)build).setDescription(arg_0));
            ParserUtils.optString(object, BUILT_ON).ifPresent(arg_0 -> ((Build)build).setBuiltOn(arg_0));
            ParserUtils.optString(object, RESULT).map(Result::fromString).ifPresent(arg_0 -> ((Build)build).setResult(arg_0));
            ParserUtils.optBoolean(object, BUILDING).ifPresent(arg_0 -> ((Build)build).setBuilding(arg_0));
            ParserUtils.optLong(object, TIMESTAMP).ifPresent(arg_0 -> ((Build)build).setTimestamp(arg_0));
            ParserUtils.optLong(object, DURATION).ifPresent(arg_0 -> ((Build)build).setDuration(arg_0));
            return true;
        }
        return false;
    }

    @Override
    public List<String> fields() {
        return Arrays.asList(NUMBER, DISPLAY_NAME, FULL_DISPLAY_NAME, DESCRIPTION, BUILT_ON, RESULT, BUILDING, TIMESTAMP, DURATION);
    }
}

