/*
 * Decompiled with CFR 0.152.
 */
package org.marvelution.jji.synctoken.jersey;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Optional;
import javax.ws.rs.core.MultivaluedMap;
import org.marvelution.jji.synctoken.CanonicalHttpServletRequest;
import org.marvelution.jji.synctoken.SyncTokenBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncTokenClientFilter
extends ClientFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTokenClientFilter.class);
    private final String identifier;
    private final String sharedSecret;
    private final Optional<String> contextPath;

    public SyncTokenClientFilter(String identifier, String sharedSecret, Optional<String> contextPath) {
        this.identifier = identifier;
        this.sharedSecret = sharedSecret;
        this.contextPath = contextPath;
    }

    public ClientResponse handle(ClientRequest request) {
        CanonicalHttpServletRequest canonicalHttpRequest = new CanonicalHttpServletRequest(request.getMethod(), request.getURI(), this.contextPath);
        LOGGER.debug("Adding {} header for request {}", (Object)"X-Sync-Token", (Object)canonicalHttpRequest);
        new SyncTokenBuilder().identifier(this.identifier).sharedSecret(this.sharedSecret).request(canonicalHttpRequest).generateTokenAndAddHeaders((arg_0, arg_1) -> ((MultivaluedMap)request.getHeaders()).add(arg_0, arg_1));
        return this.getNext().handle(request);
    }
}

